/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.morerecipes.recipes;

import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.morerecipes.BaseRecipe;
import com.github.sachin.tweakin.modules.morerecipes.MoreRecipesTweak;
import com.google.common.base.Enums;
import java.util.Arrays;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;

public class MoreBlocks
extends BaseRecipe {
    public MoreBlocks(MoreRecipesTweak instance) {
        super("more-blocks", instance);
    }

    @Override
    public void register() {
        ShapedRecipe recipe;
        NamespacedKey key;
        ConfigurationSection section = this.instance.getRecipeFile().getConfigurationSection("more-blocks");
        int trapdoorcount = section.getInt("trapdoor", 2);
        int barkcount = section.getInt("bark", 2);
        int staircount = section.getInt("stairs", 8);
        int brickcount = section.getInt("bricks", 4);
        for (Material plank : Tag.PLANKS.getValues()) {
            Material trapdoor = (Material)Enums.getIfPresent(Material.class, (String)plank.toString().replace("PLANKS", "TRAPDOOR")).orNull();
            if (trapdoor == null) continue;
            key = Tweakin.getKey(String.valueOf(this.name) + "-" + trapdoor.toString().toLowerCase());
            recipe = new ShapedRecipe(key, new ItemStack(trapdoor, trapdoorcount)).shape(new String[]{"PPP", "PPP"}).setIngredient('P', plank);
            this.addRecipe(key, (Recipe)recipe);
        }
        for (Material mat : Arrays.asList(Material.ACACIA_LOG, Material.BIRCH_LOG, Material.DARK_OAK_LOG, Material.JUNGLE_LOG, Material.OAK_LOG, Material.SPRUCE_LOG)) {
            Material bark = (Material)Enums.getIfPresent(Material.class, (String)mat.toString().replace("LOG", "WOOD")).orNull();
            if (bark == null) continue;
            key = Tweakin.getKey(String.valueOf(this.name) + "-" + bark.toString().toLowerCase());
            recipe = new ShapedRecipe(key, new ItemStack(bark, barkcount)).shape(new String[]{"PP", "PP"}).setIngredient('P', mat);
            this.addRecipe(key, (Recipe)recipe);
            Material stripedVersion = (Material)Enums.getIfPresent(Material.class, (String)("STRIPPED_" + bark)).orNull();
            Material strippedMat = (Material)Enums.getIfPresent(Material.class, (String)("STRIPPED_" + mat)).orNull();
            if (stripedVersion == null || strippedMat == null) continue;
            NamespacedKey key2 = Tweakin.getKey(String.valueOf(this.name) + "-" + stripedVersion.toString().toLowerCase());
            ShapedRecipe recipe2 = new ShapedRecipe(key, new ItemStack(stripedVersion, barkcount)).shape(new String[]{"PP", "PP"}).setIngredient('P', strippedMat);
            this.addRecipe(key2, (Recipe)recipe2);
        }
        NamespacedKey crimsonBarkKey = Tweakin.getKey(String.valueOf(this.name) + "-crimson-wood");
        ShapedRecipe crimsonBark = new ShapedRecipe(crimsonBarkKey, new ItemStack(Material.CRIMSON_HYPHAE, barkcount)).shape(new String[]{"PP", "PP"}).setIngredient('P', Material.CRIMSON_STEM);
        this.addRecipe(crimsonBarkKey, (Recipe)crimsonBark);
        NamespacedKey warpedBarkKey = Tweakin.getKey(String.valueOf(this.name) + "-warped-wood");
        ShapedRecipe warpedBark = new ShapedRecipe(warpedBarkKey, new ItemStack(Material.WARPED_HYPHAE, barkcount)).shape(new String[]{"PP", "PP"}).setIngredient('P', Material.WARPED_STEM);
        this.addRecipe(warpedBarkKey, (Recipe)warpedBark);
        NamespacedKey strippedCrimsonBarkKey = Tweakin.getKey(String.valueOf(this.name) + "-stripped-crimson-wood");
        ShapedRecipe strippedCrimsonBark = new ShapedRecipe(strippedCrimsonBarkKey, new ItemStack(Material.STRIPPED_CRIMSON_HYPHAE, barkcount)).shape(new String[]{"PP", "PP"}).setIngredient('P', Material.STRIPPED_CRIMSON_STEM);
        this.addRecipe(strippedCrimsonBarkKey, (Recipe)strippedCrimsonBark);
        NamespacedKey strippedWarpedBarkKey = Tweakin.getKey(String.valueOf(this.name) + "-stripped-warped-wood");
        ShapedRecipe strippedWarpedBark = new ShapedRecipe(strippedWarpedBarkKey, new ItemStack(Material.STRIPPED_WARPED_HYPHAE, barkcount)).shape(new String[]{"PP", "PP"}).setIngredient('P', Material.STRIPPED_WARPED_STEM);
        this.addRecipe(strippedWarpedBarkKey, (Recipe)strippedWarpedBark);
        NamespacedKey brickKey = Tweakin.getKey(String.valueOf(this.name) + "-bricks");
        ShapedRecipe bricks = new ShapedRecipe(brickKey, new ItemStack(Material.BRICKS, brickcount)).shape(new String[]{"PPP", "PPP", "PPP"}).setIngredient('P', Material.BRICK);
        this.addRecipe(brickKey, (Recipe)bricks);
        NamespacedKey netherBrickKey = Tweakin.getKey(String.valueOf(this.name) + "-nether-bricks");
        ShapedRecipe netherBricks = new ShapedRecipe(netherBrickKey, new ItemStack(Material.NETHER_BRICKS, brickcount)).shape(new String[]{"PPP", "PPP", "PPP"}).setIngredient('P', Material.NETHER_BRICK);
        this.addRecipe(netherBrickKey, (Recipe)netherBricks);
        this.StairRecipe(Material.PURPUR_STAIRS, Material.PURPUR_BLOCK, staircount);
        this.StairRecipe(Material.OAK_STAIRS, Material.OAK_PLANKS, staircount);
        this.StairRecipe(Material.ACACIA_STAIRS, Material.ACACIA_PLANKS, staircount);
        this.StairRecipe(Material.JUNGLE_STAIRS, Material.JUNGLE_PLANKS, staircount);
        this.StairRecipe(Material.BIRCH_STAIRS, Material.BIRCH_PLANKS, staircount);
        this.StairRecipe(Material.SPRUCE_STAIRS, Material.SPRUCE_PLANKS, staircount);
        this.StairRecipe(Material.DARK_OAK_STAIRS, Material.DARK_OAK_PLANKS, staircount);
        this.StairRecipe(Material.CRIMSON_STAIRS, Material.CRIMSON_PLANKS, staircount);
        this.StairRecipe(Material.WARPED_STAIRS, Material.WARPED_PLANKS, staircount);
        this.StairRecipe(Material.COBBLESTONE_STAIRS, Material.COBBLESTONE, staircount);
        this.StairRecipe(Material.BRICK_STAIRS, Material.BRICKS, staircount);
        this.StairRecipe(Material.STONE_BRICK_STAIRS, Material.STONE_BRICKS, staircount);
        this.StairRecipe(Material.NETHER_BRICK_STAIRS, Material.NETHER_BRICKS, staircount);
        this.StairRecipe(Material.SANDSTONE_STAIRS, Material.SANDSTONE, staircount);
        this.StairRecipe(Material.QUARTZ_STAIRS, Material.QUARTZ_BLOCK, staircount);
        this.StairRecipe(Material.PRISMARINE_STAIRS, Material.PRISMARINE, staircount);
        this.StairRecipe(Material.PRISMARINE_BRICK_STAIRS, Material.PRISMARINE_BRICKS, staircount);
        this.StairRecipe(Material.DARK_PRISMARINE_STAIRS, Material.DARK_PRISMARINE, staircount);
        this.StairRecipe(Material.RED_SANDSTONE_STAIRS, Material.RED_SANDSTONE, staircount);
        this.StairRecipe(Material.POLISHED_GRANITE_STAIRS, Material.POLISHED_GRANITE, staircount);
        this.StairRecipe(Material.SMOOTH_RED_SANDSTONE_STAIRS, Material.RED_SANDSTONE, staircount);
        this.StairRecipe(Material.MOSSY_COBBLESTONE_STAIRS, Material.MOSSY_COBBLESTONE, staircount);
        this.StairRecipe(Material.POLISHED_DIORITE_STAIRS, Material.POLISHED_DIORITE, staircount);
        this.StairRecipe(Material.MOSSY_COBBLESTONE_STAIRS, Material.MOSSY_COBBLESTONE, staircount);
        this.StairRecipe(Material.END_STONE_BRICK_STAIRS, Material.END_STONE_BRICKS, staircount);
        this.StairRecipe(Material.STONE_STAIRS, Material.STONE, staircount);
        this.StairRecipe(Material.SMOOTH_QUARTZ_STAIRS, Material.SMOOTH_QUARTZ, staircount);
        this.StairRecipe(Material.GRANITE_STAIRS, Material.GRANITE, staircount);
        this.StairRecipe(Material.ANDESITE_STAIRS, Material.ANDESITE, staircount);
        this.StairRecipe(Material.DIORITE_STAIRS, Material.DIORITE, staircount);
        this.StairRecipe(Material.RED_NETHER_BRICK_STAIRS, Material.RED_NETHER_BRICKS, staircount);
        this.StairRecipe(Material.POLISHED_ANDESITE_STAIRS, Material.POLISHED_ANDESITE, staircount);
        this.StairRecipe(Material.BLACKSTONE_STAIRS, Material.BLACKSTONE, staircount);
        this.StairRecipe(Material.POLISHED_BLACKSTONE_BRICK_STAIRS, Material.POLISHED_BLACKSTONE_BRICK_STAIRS, staircount);
        this.StairRecipe(Material.POLISHED_BLACKSTONE_STAIRS, Material.POLISHED_BLACKSTONE, staircount);
        if (this.instance.getPlugin().isPost1_17()) {
            this.StairRecipe(Material.COBBLED_DEEPSLATE_STAIRS, Material.COBBLED_DEEPSLATE, staircount);
            this.StairRecipe(Material.CUT_COPPER_STAIRS, Material.CUT_COPPER, staircount);
            this.StairRecipe(Material.DEEPSLATE_BRICK_STAIRS, Material.DEEPSLATE_BRICKS, staircount);
            this.StairRecipe(Material.DEEPSLATE_TILE_STAIRS, Material.DEEPSLATE_TILES, staircount);
            this.StairRecipe(Material.EXPOSED_CUT_COPPER_STAIRS, Material.EXPOSED_CUT_COPPER, staircount);
            this.StairRecipe(Material.OXIDIZED_CUT_COPPER_STAIRS, Material.OXIDIZED_CUT_COPPER, staircount);
            this.StairRecipe(Material.POLISHED_DEEPSLATE_STAIRS, Material.POLISHED_DEEPSLATE, staircount);
            this.StairRecipe(Material.WAXED_CUT_COPPER_STAIRS, Material.WAXED_CUT_COPPER, staircount);
            this.StairRecipe(Material.WAXED_EXPOSED_CUT_COPPER_STAIRS, Material.WAXED_EXPOSED_CUT_COPPER_STAIRS, staircount);
            this.StairRecipe(Material.WAXED_OXIDIZED_CUT_COPPER_STAIRS, Material.WAXED_OXIDIZED_CUT_COPPER, staircount);
            this.StairRecipe(Material.WAXED_WEATHERED_CUT_COPPER_STAIRS, Material.WAXED_WEATHERED_CUT_COPPER, staircount);
            this.StairRecipe(Material.WEATHERED_CUT_COPPER_STAIRS, Material.WEATHERED_CUT_COPPER, staircount);
        }
    }

    private void StairRecipe(Material stair, Material ing, int count) {
        NamespacedKey key = Tweakin.getKey(String.valueOf(this.name) + "-" + stair.toString().toLowerCase());
        ShapedRecipe recipe = new ShapedRecipe(key, new ItemStack(stair, count)).shape(new String[]{"P  ", "PP ", "PPP"}).setIngredient('P', ing);
        this.addRecipe(key, (Recipe)recipe);
    }
}

