/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.morerecipes;

import com.github.sachin.tweakin.modules.morerecipes.MoreRecipesTweak;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Recipe;

public abstract class BaseRecipe {
    public final String name;
    public final MoreRecipesTweak instance;
    protected List<NamespacedKey> recipes = new ArrayList<NamespacedKey>();

    public BaseRecipe(String name, MoreRecipesTweak instance) {
        this.name = name;
        this.instance = instance;
    }

    public abstract void register();

    public void unregister() {
        if (this.recipes.isEmpty()) {
            return;
        }
        for (NamespacedKey namespacedKey : this.recipes) {
            Bukkit.removeRecipe((NamespacedKey)namespacedKey);
        }
        this.recipes.clear();
    }

    public List<NamespacedKey> getRecipes() {
        return this.recipes;
    }

    public void addRecipe(NamespacedKey key, Recipe recipe) {
        if (!this.recipes.contains(key)) {
            try {
                Bukkit.addRecipe((Recipe)recipe);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.recipes.add(key);
        }
    }
}

