/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.mobheads;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.mobheads.Head;
import com.github.sachin.tweakin.modules.mobheads.HeadManager;
import com.github.sachin.tweakin.nbtapi.NBTItem;
import com.github.sachin.tweakin.utils.ConfigUpdater;
import com.github.sachin.tweakin.utils.CustomBlockData;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import com.google.common.base.Enums;
import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

@Tweak(name="mob-heads")
public class MobHeadsTweak
extends BaseTweak
implements Listener {
    public static FileConfiguration headConfig;
    private final NamespacedKey key = Tweakin.getKey("mob-head-enum");
    private HeadManager manager;

    @Override
    public void onLoad() {
        super.onLoad();
        File file = new File(this.plugin.getDataFolder(), "heads.yml");
        if (!file.exists()) {
            this.plugin.saveResource("heads.yml", false);
        }
        try {
            ConfigUpdater.update(this.plugin, "heads.yml", file, new ArrayList<String>(), false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        headConfig = YamlConfiguration.loadConfiguration((File)file);
        this.manager = new HeadManager(this);
    }

    @EventHandler
    public void onHeadDrops(ItemSpawnEvent e) {
        Optional head;
        CustomBlockData data;
        if ((e.getEntity().getItemStack().getType() == Material.PLAYER_HEAD || e.getEntity().getItemStack().getType() == Material.PLAYER_WALL_HEAD) && (data = new CustomBlockData(e.getEntity().getLocation())).has(this.key, PersistentDataType.STRING) && (head = Enums.getIfPresent(Head.class, (String)((String)data.get(this.key, PersistentDataType.STRING)))).isPresent()) {
            data.remove(this.key);
            e.getEntity().setItemStack(((Head)((Object)head.get())).getSkull());
        }
    }

    @EventHandler
    public void onHeadBreak(BlockBreakEvent e) {
        CustomBlockData data;
        if ((e.getBlock().getType() == Material.PLAYER_HEAD || e.getBlock().getType() == Material.PLAYER_WALL_HEAD) && !e.isDropItems() && (data = new CustomBlockData(e.getBlock().getLocation())).has(this.key, PersistentDataType.STRING)) {
            data.remove(this.key);
        }
    }

    @EventHandler
    public void onHeadPlace(BlockPlaceEvent e) {
        NBTItem nbti = new NBTItem(e.getItemInHand());
        if (nbti.hasKey("mob-head-item")) {
            CustomBlockData data = new CustomBlockData(e.getBlockPlaced().getLocation());
            data.set(this.key, PersistentDataType.STRING, nbti.getString("mob-head-item"));
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent e) {
        block15: {
            Head validHead;
            LivingEntity killed;
            block17: {
                List heads;
                block16: {
                    killed = e.getEntity();
                    if (this.getBlackListWorlds().contains(killed.getWorld().getName())) {
                        return;
                    }
                    if (killed instanceof Player || (heads = (List)this.manager.getMultiHeadMap().getOrDefault(killed.getType(), new ArrayList())).isEmpty()) break block15;
                    validHead = null;
                    if (killed.getType() != EntityType.WITHER) break block16;
                    double total = 0.0;
                    TreeMap<Double, Head> map = new TreeMap<Double, Head>();
                    for (Head h : heads) {
                        map.put(total += h.getChance(), h);
                    }
                    Map.Entry entry = null;
                    double value = Math.random();
                    entry = map.ceilingEntry(value);
                    if (entry == null) break block17;
                    validHead = (Head)((Object)entry.getValue());
                    break block17;
                }
                for (Head h : heads) {
                    if (!h.check((Entity)killed)) continue;
                    validHead = h;
                    break;
                }
            }
            if (validHead != null) {
                boolean requirePlayerKill = this.getConfig().getBoolean("require-player-kill");
                if (requirePlayerKill && killed.getKiller() != null) {
                    Player killer = killed.getKiller();
                    if (!this.hasPermission(killer, Permissions.MOBHEADS)) {
                        return;
                    }
                    ItemStack item1 = killer.getInventory().getItemInMainHand();
                    ItemStack item2 = killer.getInventory().getItemInOffHand();
                    if (item1 != null) {
                        if (validHead.hasChance(item1.getEnchantmentLevel(Enchantment.LOOT_BONUS_MOBS))) {
                            e.getDrops().add(validHead.getSkull());
                        }
                    } else if (item2 != null) {
                        if (validHead.hasChance(item2.getEnchantmentLevel(Enchantment.LOOT_BONUS_MOBS))) {
                            e.getDrops().add(validHead.getSkull());
                        }
                    } else if (validHead.hasChance()) {
                        e.getDrops().add(validHead.getSkull());
                    }
                } else if (!requirePlayerKill && validHead.hasChance()) {
                    e.getDrops().add(validHead.getSkull());
                }
            }
        }
    }
}

