/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.infinitybucket;

import com.github.sachin.tweakin.TweakItem;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Directional;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Fish;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.player.PlayerBucketEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

@Tweak(name="infinity-water-bucket")
public class InfinityWaterBucketTweak
extends TweakItem
implements Listener {
    @EventHandler
    public void onDispenseItem(BlockDispenseEvent e) {
        if (e.getBlock().getType() == Material.DISPENSER && this.getConfig().getBoolean("dispenser-usable") && this.getItem().isSimilar(e.getItem())) {
            e.setCancelled(true);
            Directional directional = (Directional)e.getBlock().getBlockData();
            Block relative = e.getBlock().getRelative(directional.getFacing());
            if (e.getBlock().getWorld().getEnvironment() == World.Environment.NETHER) {
                return;
            }
            if (relative.getType() == Material.AIR) {
                relative.getWorld().playSound(relative.getLocation(), Sound.ITEM_BUCKET_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                relative.setType(Material.WATER, true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAnvilUse(PrepareAnvilEvent e) {
        if (e.getView().getBottomInventory().getHolder() instanceof Player) {
            EnchantmentStorageMeta enchMeta;
            Map enchs;
            Player player = (Player)e.getView().getBottomInventory().getHolder();
            if (!this.hasPermission(player, Permissions.INFIBUCKET_CRAFT)) {
                return;
            }
            AnvilInventory inv = e.getInventory();
            ItemStack slot1 = inv.getItem(0);
            ItemStack slot2 = inv.getItem(1);
            if (slot1 == null || slot2 == null) {
                return;
            }
            if (slot1.getType() == Material.WATER_BUCKET && slot2.getType() == Material.ENCHANTED_BOOK && (enchs = (enchMeta = (EnchantmentStorageMeta)slot2.getItemMeta()).getStoredEnchants()).containsKey(Enchantment.ARROW_INFINITE) && (Integer)enchs.get(Enchantment.ARROW_INFINITE) > 0) {
                ItemStack result = this.getItem().clone();
                ItemMeta meta = result.getItemMeta();
                meta.setDisplayName(inv.getRenameText());
                result.setItemMeta(meta);
                inv.setRepairCost(this.getConfig().getInt("cost"));
                e.setResult(result);
            }
        }
    }

    @EventHandler
    public void onBucketUse(PlayerInteractEvent e) {
        if (this.isSimilar(e.getItem()) && e.getAction() == Action.RIGHT_CLICK_BLOCK && e.useItemInHand() != Event.Result.DENY) {
            Player player = e.getPlayer();
            e.setCancelled(true);
            if (!this.hasPermission(player, Permissions.INFIBUCKET_USE) || player.getWorld().getEnvironment() == World.Environment.NETHER) {
                return;
            }
            Block block = e.getClickedBlock().getRelative(e.getBlockFace());
            if (this.plugin.griefCompat != null && !this.plugin.griefCompat.canBuild(player, block.getLocation(), Material.WATER_BUCKET)) {
                return;
            }
            if (!block.isEmpty() && block.getBlockData() instanceof Waterlogged) {
                this.plugin.getNmsHelper().placeWater(block);
            } else {
                block.setType(Material.WATER, true);
            }
        }
    }

    @EventHandler
    public void onFishPickUp(PlayerBucketEntityEvent e) {
        Player player = e.getPlayer();
        ItemStack item = e.getOriginalBucket();
        if (item == null) {
            return;
        }
        if (!item.isSimilar(this.getItem())) {
            return;
        }
        if (e.getEntity() instanceof Fish) {
            e.setCancelled(true);
            player.sendMessage(this.getTweakManager().getMessageManager().getMessage("cant-catch-fish"));
        } else if (this.plugin.getVersion().startsWith("v1_17") && e.getEntity().getType().toString().equals("AXOLOTL")) {
            e.setCancelled(true);
            player.sendMessage(this.getTweakManager().getMessageManager().getMessage("cant-catch-axolotl"));
        }
    }
}

