/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.infinitefirework;

import com.github.sachin.tweakin.TweakItem;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.TConstants;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;

@Tweak(name="infinite-firework")
public class InfiniteFireworkItem
extends TweakItem
implements Listener {
    @Override
    public void register() {
        super.register();
        this.registerRecipe();
    }

    @Override
    public void unregister() {
        super.unregister();
        this.unregisterRecipe();
    }

    @EventHandler
    public void onDispense(BlockDispenseEvent e) {
        if (this.isSimilar(e.getItem()) && e.getBlock().getType() == Material.DISPENSER) {
            if (!this.getConfig().getBoolean("dispenser-usable")) {
                e.setCancelled(true);
                return;
            }
            ItemStack item = new ItemStack(Material.FIREWORK_ROCKET);
            FireworkMeta meta = (FireworkMeta)item.getItemMeta();
            item.setItemMeta((ItemMeta)this.getRandomFireworkEffect(meta));
            e.setItem(item);
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        if (!this.isSimilar(e.getItem())) {
            return;
        }
        Player player = e.getPlayer();
        if (e.getAction() == Action.RIGHT_CLICK_AIR && player.isGliding()) {
            e.setCancelled(true);
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            e.setCancelled(true);
            if (!this.hasPermission(player, Permissions.INFIFIREWORK_USE)) {
                return;
            }
            RayTraceResult raytrace = player.rayTraceBlocks(4.0);
            if (raytrace != null && raytrace.getHitPosition() != null) {
                Vector vec = raytrace.getHitPosition();
                BlockFace clickedFace = e.getBlockFace();
                this.getRandomFireWork(new Location(player.getWorld(), vec.getX() + (double)clickedFace.getModX() * 0.15, vec.getY() + (double)clickedFace.getModY() * 0.15, vec.getZ() + (double)clickedFace.getModZ() * 0.15), (ProjectileSource)player);
            }
        }
    }

    public FireworkMeta getRandomFireworkEffect(FireworkMeta meta) {
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        meta.setPower(rand.nextInt(this.getConfig().getInt("min-flight"), this.getConfig().getInt("max-flight")));
        int i = 0;
        while (i < rand.nextInt(this.getConfig().getInt("min-effects"), this.getConfig().getInt("max-effects"))) {
            FireworkEffect.Builder builder = FireworkEffect.builder();
            builder.flicker(this.plugin.RANDOM.nextBoolean()).trail(this.plugin.RANDOM.nextBoolean()).with(this.getRandomEnum(FireworkEffect.Type.class)).withColor(Color.fromBGR((int)rand.nextInt(0, 254), (int)rand.nextInt(0, 254), (int)rand.nextInt(0, 254)));
            meta.addEffect(builder.build());
            ++i;
        }
        return meta;
    }

    public Firework getRandomFireWork(Location loc, ProjectileSource source) {
        Firework entity = (Firework)loc.getWorld().spawn(loc, Firework.class);
        entity.getPersistentDataContainer().set(TConstants.INFINITE_FIREWORK_KEY, PersistentDataType.INTEGER, (Object)1);
        if (source != null) {
            entity.setShooter(source);
        }
        entity.setFireworkMeta(this.getRandomFireworkEffect(entity.getFireworkMeta()));
        return entity;
    }

    @EventHandler
    public void onExplode(EntityDamageByEntityEvent e) {
        if (e.getDamager().getPersistentDataContainer().has(TConstants.INFINITE_FIREWORK_KEY, PersistentDataType.INTEGER)) {
            e.setCancelled(true);
        }
    }

    public <T extends Enum<T>> T getRandomEnum(Class<T> clazz) {
        return (T)Arrays.asList((Enum[])clazz.getEnumConstants()).get(this.plugin.RANDOM.nextInt(((Enum[])clazz.getEnumConstants()).length));
    }
}

