/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.hoeharvesting;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.ItemBuilder;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

@Tweak(name="hoe-harvesting")
public class HoeHarvestingTweak
extends BaseTweak
implements Listener {
    private int getRange(String itemType) {
        switch (itemType) {
            case "WOODEN_HOE": {
                return this.getConfig().getInt("range.wooden");
            }
            case "STONE_HOE": {
                return this.getConfig().getInt("range.stone");
            }
            case "IRON_HOE": {
                return this.getConfig().getInt("range.iron");
            }
            case "DIAMOND_HOE": {
                return this.getConfig().getInt("range.diamond");
            }
            case "NETHERITE_HOE": {
                return this.getConfig().getInt("range.netherite");
            }
        }
        return 1;
    }

    @EventHandler
    public void onHarvest(BlockBreakEvent e) {
        Player player = e.getPlayer();
        if (!player.isSneaking() && this.getConfig().getBoolean("require-sneaking")) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        Location breakedBlock = e.getBlock().getLocation();
        if (this.matchesHarvestable(e.getBlock().getType())) {
            if (item == null) {
                return;
            }
            String itemType = item.getType().toString();
            if (!itemType.endsWith("_HOE")) {
                return;
            }
            int range = this.getRange(itemType);
            int x = breakedBlock.getBlockX() - range;
            while (x <= breakedBlock.getBlockX() + range) {
                int z = breakedBlock.getBlockZ() - range;
                while (z <= breakedBlock.getBlockZ() + range) {
                    Location loc = new Location(breakedBlock.getWorld(), (double)x, (double)breakedBlock.getBlockY(), (double)z);
                    Material blockType = loc.getBlock().getType();
                    if (this.matchesHarvestable(blockType)) {
                        loc.getBlock().breakNaturally(item);
                        ItemBuilder.damageItem(1, item, this.plugin.RANDOM, player);
                    }
                    ++z;
                }
                ++x;
            }
        }
    }

    private boolean matchesHarvestable(Material mat) {
        return this.matchString(mat.toString(), this.getConfig().getStringList("harvestable-materials")) || this.matchTag(mat, this.getConfig().getStringList("harvestable-materials"));
    }
}

