/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.fastleafdecay;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.plugin.Plugin;

@Tweak(name="fast-leaf-decay")
public class FastLeafDecayTweak
extends BaseTweak
implements Listener {
    private int duration;

    @Override
    public void reload() {
        super.reload();
        this.duration = this.getConfig().getInt("duration", 10) * 20;
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onLeafDecay(LeavesDecayEvent e) {
        if (e instanceof LeavesDecayEventForChecking) {
            return;
        }
        if (this.getBlackListWorlds().contains(e.getBlock().getWorld().getName())) {
            return;
        }
        e.setCancelled(true);
        Block block = e.getBlock();
        this.removeLeaves(block.getLocation());
    }

    private void removeLeaves(Location startLocation) {
        List<Location> leavesLocations = this.getNearbyLeaves(startLocation, 10);
        for (Location location : leavesLocations) {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.getPlugin(), () -> {
                Block block = location.getBlock();
                LeavesDecayEventForChecking event = new LeavesDecayEventForChecking(block);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (!event.isCancelled()) {
                    block.breakNaturally();
                }
            }, (long)ThreadLocalRandom.current().nextInt(this.duration));
        }
    }

    public List<Location> getNearbyLeaves(Location location, int radius) {
        ArrayList<Location> locs = new ArrayList<Location>();
        int x = location.getBlockX() - radius;
        while (x <= location.getBlockX() + radius) {
            int y = location.getBlockY() - radius;
            while (y <= location.getBlockY() + radius) {
                int z = location.getBlockZ() - radius;
                while (z <= location.getBlockZ() + radius) {
                    Leaves leaves;
                    Block block = location.getWorld().getBlockAt(x, y, z);
                    if (!block.getType().isAir() && this.isLeaf(block) && !(leaves = (Leaves)block.getBlockData()).isPersistent() && leaves.getDistance() > 6 && !locs.contains(block.getLocation())) {
                        locs.add(block.getLocation());
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
        return locs;
    }

    private boolean isLeaf(Block block) {
        return Tag.LEAVES.isTagged((Keyed)block.getType());
    }

    private static class LeavesDecayEventForChecking
    extends LeavesDecayEvent {
        public LeavesDecayEventForChecking(Block block) {
            super(block);
        }
    }
}

