/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.coordinatehud;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.acf.BaseCommand;
import com.github.sachin.tweakin.compat.PlaceHolderApiCompat;
import com.github.sachin.tweakin.modules.coordinatehud.ToggleCommand;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Config;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="coordinate-hud")
public class CoordinateHUDTweak
extends BaseTweak
implements Listener {
    final List<Player> enabled = new ArrayList<Player>();
    final Map<UUID, BossBar> bars = new HashMap<UUID, BossBar>();
    final Map<Vehicle, SpeedData> speedDataMap = new HashMap<Vehicle, SpeedData>();
    final NamespacedKey key = new NamespacedKey((Plugin)this.getPlugin(), "coordinatehud");
    final NamespacedKey firstKey = new NamespacedKey((Plugin)this.getPlugin(), "coordinatehud-firstJoin");
    final List<EntityType> validVehicles = Arrays.asList(EntityType.HORSE, EntityType.MINECART, EntityType.BOAT, EntityType.MULE, EntityType.DONKEY, EntityType.STRIDER, EntityType.LLAMA, EntityType.PIG, EntityType.SKELETON_HORSE);
    private BaseCommand command;
    private HUDRunnable runnable;
    @Config(key="interval-ticks")
    private int intervalTicks;
    @Config(key="hud-type")
    private String msgType = "ACTIONBAR";
    @Config(key="boss-bar.color")
    private String color = "YELLOW";
    @Config(key="boss-bar.style")
    private String style = "SEGMENTED_6";
    @Config(key="enable-on-first-join")
    private boolean enableOnFirstJoin = true;

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        this.addPlayerToHud(player);
    }

    public void addPlayerToHud(Player player) {
        if (!player.getPersistentDataContainer().has(this.firstKey, PersistentDataType.INTEGER) && this.enableOnFirstJoin) {
            this.enabled.add(player);
            player.getPersistentDataContainer().set(this.firstKey, PersistentDataType.INTEGER, (Object)1);
            player.getPersistentDataContainer().set(this.key, PersistentDataType.INTEGER, (Object)1);
            if (this.isBossBar()) {
                this.createBossBar(player);
            }
        } else if (player.getPersistentDataContainer().has(this.key, PersistentDataType.INTEGER)) {
            this.enabled.add(player);
            if (this.isBossBar()) {
                this.createBossBar(player);
            }
        }
    }

    public boolean isBossBar() {
        return this.msgType.equals("BOSSBAR");
    }

    public void createBossBar(Player player) {
        BossBar bar = Bukkit.createBossBar((String)"", (BarColor)((BarColor)Enums.getIfPresent(BarColor.class, (String)this.color).or((Object)BarColor.YELLOW)), (BarStyle)((BarStyle)Enums.getIfPresent(BarStyle.class, (String)this.style).or((Object)BarStyle.SEGMENTED_6)), (BarFlag[])new BarFlag[0]);
        bar.addPlayer(player);
        this.bars.put(player.getUniqueId(), bar);
    }

    public void removeBossBar(Player player) {
        if (this.bars.containsKey(player.getUniqueId())) {
            BossBar bar = this.bars.remove(player.getUniqueId());
            bar.removeAll();
        }
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        this.enabled.remove(e.getPlayer());
    }

    @Override
    public void register() {
        super.register();
        this.command = new ToggleCommand(this);
        this.registerCommands(this.command);
        this.runnable = new HUDRunnable();
        this.runnable.runTaskTimer((Plugin)this.getPlugin(), 1L, this.intervalTicks);
        this.enabled.clear();
        Bukkit.getOnlinePlayers().forEach(player -> this.addPlayerToHud((Player)player));
    }

    @Override
    public void unregister() {
        super.unregister();
        this.unregisterCommands(this.command);
        if (!this.bars.isEmpty()) {
            for (UUID id : this.bars.keySet()) {
                this.bars.get(id).removeAll();
            }
            this.bars.clear();
        }
        if (this.runnable != null) {
            this.runnable.cancel();
            this.enabled.clear();
        }
    }

    private double getSpeed(Vehicle vh) {
        SpeedData data = this.speedDataMap.get(vh);
        this.speedDataMap.put(vh, new SpeedData(vh.getLocation()));
        if (data == null) {
            return 0.0;
        }
        long timeDifference = System.currentTimeMillis() - data.getTime();
        double distance = data.getLocation().distance(vh.getLocation());
        double speed = distance / (double)timeDifference * 1000.0;
        return speed;
    }

    public String getDirection(float yaw) {
        double degrees;
        double d = degrees = yaw < 0.0f ? (double)yaw % -360.0 + 360.0 : (double)yaw % 360.0;
        if (degrees <= 22.5) {
            return "S";
        }
        if (degrees <= 67.5) {
            return "SW";
        }
        if (degrees <= 112.5) {
            return "W";
        }
        if (degrees <= 157.5) {
            return "NW";
        }
        if (degrees <= 202.5) {
            return "N";
        }
        if (degrees <= 247.5) {
            return "NE";
        }
        if (degrees <= 292.5) {
            return "E";
        }
        if (degrees <= 337.5) {
            return "SE";
        }
        return "S";
    }

    private class HUDRunnable
    extends BukkitRunnable {
        private HUDRunnable() {
        }

        public void run() {
            CoordinateHUDTweak.this.enabled.forEach(player -> {
                EntityType vechType;
                if (!player.getInventory().contains(Material.COMPASS) && CoordinateHUDTweak.this.getConfig().getBoolean("have-compass", false) && !CoordinateHUDTweak.this.hasPermission((Player)player, Permissions.HUD_COMPASSBYPASS)) {
                    return;
                }
                long time = (player.getWorld().getTime() + 6000L) % 24000L;
                long hours = time / 1000L;
                Long extra = (time - hours * 1000L) * 60L / 1000L;
                String message = CoordinateHUDTweak.this.getConfig().getString("text").replace("%x%", String.valueOf(player.getLocation().getBlockX())).replace("%y%", String.valueOf(player.getLocation().getBlockY())).replace("%z%", String.valueOf(player.getLocation().getBlockZ())).replace("%direction%", CoordinateHUDTweak.this.getDirection(player.getLocation().getYaw())).replace("%time%", String.valueOf(hours) + ":" + extra);
                if (CoordinateHUDTweak.this.getConfig().getBoolean("placeholderapi-support", false) && PlaceHolderApiCompat.isEnabled) {
                    message = PlaceHolderApiCompat.parse(player, message);
                }
                if (CoordinateHUDTweak.this.getConfig().getBoolean("show-speed", true) && player.isInsideVehicle() && CoordinateHUDTweak.this.validVehicles.contains(vechType = player.getVehicle().getType())) {
                    Vehicle vh = (Vehicle)player.getVehicle();
                    message = String.valueOf(message) + ChatColor.GOLD + " Speed: " + ChatColor.RESET + (double)Math.round(CoordinateHUDTweak.this.getSpeed(vh) * 100.0) / 100.0;
                }
                message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
                if (CoordinateHUDTweak.this.isBossBar()) {
                    if (CoordinateHUDTweak.this.bars.containsKey(player.getUniqueId())) {
                        CoordinateHUDTweak.this.bars.get(player.getUniqueId()).setTitle(message);
                    }
                } else {
                    player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(message));
                }
            });
        }
    }

    private class SpeedData {
        private Location loc;
        private final long time = System.currentTimeMillis();

        public SpeedData(Location loc) {
            this.loc = loc.clone();
        }

        public long getTime() {
            return this.time;
        }

        public Location getLocation() {
            return this.loc;
        }
    }
}

