/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.confetticreepers;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="confetti-creepers")
public class ConfettiCreepers
extends BaseTweak
implements Listener {
    private FireworkEffect.Builder builder;

    @Override
    public void reload() {
        super.reload();
        this.builder = FireworkEffect.builder();
        this.builder.with(FireworkEffect.Type.BURST);
        List colors = this.getConfig().getIntegerList("colors");
        ArrayList<Color> fireWorkColors = new ArrayList<Color>();
        if (!colors.isEmpty()) {
            for (Integer color : colors) {
                fireWorkColors.add(Color.fromRGB((int)color));
            }
            this.builder.flicker(true);
            this.builder.withColor(fireWorkColors);
        }
    }

    @EventHandler
    public void onCreeperExplode(ExplosionPrimeEvent e) {
        if (e.getEntityType() != EntityType.CREEPER) {
            return;
        }
        Creeper creeper = (Creeper)e.getEntity();
        if (this.getBlackListWorlds().contains(creeper.getWorld().getName())) {
            return;
        }
        if (Math.random() < this.getConfig().getDouble("chance", 1.0)) {
            e.setCancelled(true);
            final Firework firework = (Firework)creeper.getWorld().spawn(creeper.getLocation().clone().subtract(0.0, 0.2, 0.0), Firework.class);
            FireworkMeta meta = firework.getFireworkMeta();
            meta.addEffect(this.builder.build());
            firework.setFireworkMeta(meta);
            new BukkitRunnable(){

                public void run() {
                    firework.detonate();
                }
            }.runTaskLater((Plugin)this.getPlugin(), 2L);
            creeper.remove();
        }
    }
}

