/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.chickenshearing;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.ItemBuilder;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.TConstants;
import com.github.sachin.tweakin.utils.annotations.Config;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.Iterator;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Chicken;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="chicken-shearing")
public class ChickenShearingTweak
extends BaseTweak
implements Listener {
    private int minDamage = 0;
    private int maxDamage = 0;
    @Config(key="cooldown")
    private int cooldown = 20;
    @Config(key="drop-feathers-on-death")
    private boolean dropFeathersOnDeath = false;
    @Config(key="dispenser-usable")
    private boolean dispenserUsable = true;

    @Override
    public void reload() {
        super.reload();
        String[] damage = this.getConfig().getString("damage").split("-");
        this.minDamage = Integer.parseInt(damage[0]);
        this.maxDamage = Integer.parseInt(damage[1]);
    }

    @EventHandler
    public void onDispenseItem(BlockDispenseEvent e) {
        if (e.getBlock().getType() == Material.DISPENSER && this.dispenserUsable && !this.containsWorld(e.getBlock().getWorld()) && e.getItem().getType() == Material.SHEARS) {
            Directional directional = (Directional)e.getBlock().getBlockData();
            Block relative = e.getBlock().getRelative(directional.getFacing());
            final ItemStack shears = e.getItem();
            Iterator iterator = relative.getWorld().getNearbyEntities(relative.getLocation().add(0.5, 0.5, 0.5), 0.5, 0.5, 0.5, en -> en.getType() == EntityType.CHICKEN && ((Chicken)en).isAdult() && !en.isDead()).iterator();
            if (iterator.hasNext()) {
                Entity en2 = (Entity)iterator.next();
                relative.getWorld().playSound(en2.getLocation(), Sound.ENTITY_SHEEP_SHEAR, 1.0f, 1.0f);
                if (!en2.getPersistentDataContainer().has(TConstants.SHEARED_CHICKEN_KEY, PersistentDataType.INTEGER)) {
                    en2.getPersistentDataContainer().set(TConstants.SHEARED_CHICKEN_KEY, PersistentDataType.INTEGER, (Object)1);
                }
                ((Chicken)en2).damage((double)ThreadLocalRandom.current().nextInt(this.minDamage, this.maxDamage));
                en2.getWorld().dropItem(en2.getLocation(), new ItemStack(Material.FEATHER));
                final Dispenser dispenser = (Dispenser)e.getBlock().getState();
                new BukkitRunnable(){

                    public void run() {
                        ItemStack damagedShears = ItemBuilder.damageItem(1, shears.clone(), ((ChickenShearingTweak)ChickenShearingTweak.this).plugin.RANDOM, null);
                        int slot = dispenser.getInventory().first(shears);
                        if (slot != -1) {
                            dispenser.getSnapshotInventory().setItem(slot, damagedShears);
                            dispenser.update(true);
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, 1L);
            }
        }
    }

    @EventHandler
    public void onShearsUsed(PlayerInteractEntityEvent e) {
        if (e.getRightClicked() instanceof Chicken) {
            Chicken chicken = (Chicken)e.getRightClicked();
            Player player = e.getPlayer();
            ItemStack shears = player.getInventory().getItem(e.getHand());
            if (shears != null && shears.getType() == Material.SHEARS && chicken.isAdult() && !chicken.isDead() && player.getCooldown(Material.SHEARS) == 0 && this.hasPermission(player, Permissions.CHICKEN_SHEARING) && !this.containsWorld(player.getWorld())) {
                this.swingHand(e.getHand(), player);
                if (player.getGameMode() != GameMode.CREATIVE) {
                    player.getInventory().setItem(e.getHand(), ItemBuilder.damageItem(1, shears, this.plugin.RANDOM, player));
                }
                player.setCooldown(Material.SHEARS, this.cooldown);
                player.getWorld().playSound(chicken.getLocation(), Sound.ENTITY_SHEEP_SHEAR, 1.0f, 1.0f);
                if (!chicken.getPersistentDataContainer().has(TConstants.SHEARED_CHICKEN_KEY, PersistentDataType.INTEGER)) {
                    chicken.getPersistentDataContainer().set(TConstants.SHEARED_CHICKEN_KEY, PersistentDataType.INTEGER, (Object)1);
                }
                chicken.damage((double)ThreadLocalRandom.current().nextInt(this.minDamage, this.maxDamage));
                player.getWorld().dropItem(chicken.getLocation(), new ItemStack(Material.FEATHER));
            }
        }
    }

    @EventHandler
    public void onChickenDeath(EntityDeathEvent e) {
        if (e.getEntity() instanceof Chicken && !this.dropFeathersOnDeath && e.getEntity().getPersistentDataContainer().has(TConstants.SHEARED_CHICKEN_KEY, PersistentDataType.INTEGER)) {
            Chicken chicken = (Chicken)e.getEntity();
            e.getDrops().removeIf(item -> item.getType() == Material.FEATHER);
        }
    }
}

