/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.bottledcloud;

import java.util.ArrayList;
import org.bukkit.util.Vector;

public class RayTrace {
    Vector origin;
    Vector direction;

    public RayTrace(Vector origin, Vector direction) {
        this.origin = origin;
        this.direction = direction;
    }

    public Vector getPostion(double blocksAway) {
        return this.origin.clone().add(this.direction.clone().multiply(blocksAway));
    }

    public boolean isOnLine(Vector position) {
        double t = (position.getX() - this.origin.getX()) / this.direction.getX();
        return (double)position.getBlockY() == this.origin.getY() + t * this.direction.getY() && (double)position.getBlockZ() == this.origin.getZ() + t * this.direction.getZ();
    }

    public ArrayList<Vector> traverse(double blocksAway, double accuracy) {
        ArrayList<Vector> positions = new ArrayList<Vector>();
        double d = 0.0;
        while (d <= blocksAway) {
            positions.add(this.getPostion(d));
            d += accuracy;
        }
        return positions;
    }

    public Vector positionOfIntersection(Vector min, Vector max, double blocksAway, double accuracy) {
        ArrayList<Vector> positions = this.traverse(blocksAway, accuracy);
        for (Vector position : positions) {
            if (!RayTrace.intersects(position, min, max)) continue;
            return position;
        }
        return null;
    }

    public boolean intersects(Vector min, Vector max, double blocksAway, double accuracy) {
        ArrayList<Vector> positions = this.traverse(blocksAway, accuracy);
        for (Vector position : positions) {
            if (!RayTrace.intersects(position, min, max)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersects(Vector position, Vector min, Vector max) {
        if (position.getX() < min.getX() || position.getX() > max.getX()) {
            return false;
        }
        if (position.getY() < min.getY() || position.getY() > max.getY()) {
            return false;
        }
        return !(position.getZ() < min.getZ()) && !(position.getZ() > max.getZ());
    }
}

