/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.bottledcloud;

import com.github.sachin.tweakin.TweakItem;
import com.github.sachin.tweakin.modules.bottledcloud.RayTrace;
import com.github.sachin.tweakin.utils.CustomBlockData;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Config;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

@Tweak(name="bottled-cloud")
public class BottledCloudItem
extends TweakItem
implements Listener {
    private ItemStack cloudItem;
    private NamespacedKey placedBlock;
    public Map<Location, CloudEntity> clouds = new HashMap<Location, CloudEntity>();
    @Config(key="minimum-height")
    private int miniHeight = 126;
    @Config(key="maximum-height")
    private int maxHeight = 132;

    @Override
    public void onLoad() {
        super.onLoad();
        this.cloudItem = new ItemStack(Material.PLAYER_HEAD);
        this.placedBlock = new NamespacedKey((Plugin)this.plugin, "cloud-occupied");
        ItemMeta meta = this.cloudItem.getItemMeta();
        SkullMeta skullMeta = (SkullMeta)meta;
        this.plugin.getNmsHelper().applyHeadTexture(skullMeta, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMzY2YTVjOTg5MjhmYTVkNGI1ZDViOGVmYjQ5MDE1NWI0ZGRhMzk1NmJjYWE5MzcxMTc3ODE0NTMyY2ZjIn19fQ==");
        this.cloudItem.setItemMeta(meta);
    }

    @EventHandler
    public void onRightClick(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        if (!this.hasPermission(player, Permissions.BOTTLEDCLOUD_USE)) {
            return;
        }
        if (this.getBlackListWorlds().contains(player.getWorld().getName())) {
            return;
        }
        if (!this.hasItem(player, EquipmentSlot.HAND)) {
            return;
        }
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK) {
            e.setCancelled(true);
        }
        if (e.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        e.setCancelled(true);
        ItemStack item = e.getItem();
        RayTrace trace = new RayTrace(player.getEyeLocation().toVector(), player.getEyeLocation().getDirection());
        ArrayList<Vector> positions = trace.traverse(4.0, 0.01);
        if (positions != null) {
            Location loc = positions.get(positions.size() - 1).toLocation(player.getWorld()).getBlock().getLocation();
            CustomBlockData data = new CustomBlockData(loc);
            if (loc.getBlock().getType().isAir() && !this.clouds.containsKey(loc) && !data.has(this.placedBlock, PersistentDataType.INTEGER)) {
                CloudEntity entity = new CloudEntity(loc);
                item.setAmount(item.getAmount() - 1);
                player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE)});
                player.swingMainHand();
                this.clouds.put(loc, entity);
                entity.initTicker();
            }
        }
    }

    @EventHandler
    public void onGlassBottleClick(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        if (this.getBlackListWorlds().contains(player.getWorld().getName())) {
            return;
        }
        if (!this.hasPermission(player, Permissions.BOTTLEDCLOUD_PICKUP)) {
            return;
        }
        if (e.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (e.getItem() == null) {
            return;
        }
        ItemStack item = e.getItem();
        if (!e.getItem().isSimilar(new ItemStack(Material.GLASS_BOTTLE))) {
            return;
        }
        if (player.getLocation().getBlockY() >= this.miniHeight && player.getLocation().getBlockY() <= this.maxHeight) {
            this.giveCloudItem(player, item);
            e.setCancelled(true);
        }
    }

    public void giveCloudItem(Player player, ItemStack item) {
        player.swingMainHand();
        player.getInventory().addItem(new ItemStack[]{this.getItem()});
        player.getWorld().playSound(player.getLocation(), Sound.ITEM_BOTTLE_FILL_DRAGONBREATH, SoundCategory.PLAYERS, 0.3f, 0.3f);
        if (player.getGameMode() != GameMode.CREATIVE) {
            item.setAmount(item.getAmount() - 1);
        }
    }

    @EventHandler
    public void onDispenseCloud(BlockDispenseEvent e) {
        if (e.getItem() != null && e.getItem().isSimilar(this.getItem())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onCloudClick(PlayerInteractEntityEvent e) {
        if (e.getHand() != EquipmentSlot.HAND) {
            return;
        }
        if (!(e.getRightClicked() instanceof MagmaCube)) {
            return;
        }
        Player player = e.getPlayer();
        if (this.hasItem(player, EquipmentSlot.HAND)) {
            return;
        }
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null) {
            return;
        }
        MagmaCube cube = (MagmaCube)e.getRightClicked();
        CloudEntity entity = null;
        for (Location loc : this.clouds.keySet()) {
            CloudEntity en = this.clouds.get(loc);
            if (cube.getUniqueId() != en.cube.getUniqueId()) continue;
            entity = en;
            break;
        }
        if (entity != null) {
            if (item.getType() == Material.GLASS_BOTTLE) {
                this.giveCloudItem(player, item);
                entity.ticker.removeAll();
                this.clouds.remove(entity.loc);
                return;
            }
            entity.ticker.removeAll();
            this.clouds.remove(entity.loc);
            boolean placed = this.getPlugin().getNmsHelper().placeItem(player, entity.loc, item, BlockFace.DOWN, this.getName(), true);
            if (placed && player.getGameMode() != GameMode.CREATIVE && !this.plugin.isPost1_18()) {
                item.setAmount(item.getAmount() - 1);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void oncloudEntitySpawnEvent(EntitySpawnEvent e) {
        Entity entity = e.getEntity();
        if (e.isCancelled() && entity.getType() == EntityType.MAGMA_CUBE && entity.getPersistentDataContainer().has(this.placedBlock, PersistentDataType.INTEGER)) {
            e.setCancelled(false);
        }
    }

    @Override
    public void onDisable() {
        for (CloudEntity entity : this.clouds.values()) {
            entity.ticker.removeAll();
        }
    }

    public class CloudEntity {
        public ArmorStand armorStand;
        public MagmaCube cube;
        public Location loc;
        public CloudTicker ticker;
        public CustomBlockData data;

        public CloudEntity(Location loc) {
            this.loc = loc;
            this.armorStand = (ArmorStand)loc.getWorld().spawn(loc.clone().add(0.5, -0.5, 0.5), ArmorStand.class);
            this.armorStand.getEquipment().setHelmet(BottledCloudItem.this.cloudItem);
            this.armorStand.setGravity(false);
            this.armorStand.setSmall(true);
            this.armorStand.setMarker(true);
            this.armorStand.setInvisible(true);
            this.cube = (MagmaCube)loc.getWorld().spawn(this.armorStand.getEyeLocation(), MagmaCube.class);
            this.cube.setSize(2);
            this.cube.setInvisible(true);
            this.cube.setAI(false);
            this.cube.setInvulnerable(true);
            this.cube.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(200.0);
            this.cube.getPersistentDataContainer().set(BottledCloudItem.this.placedBlock, PersistentDataType.INTEGER, (Object)1);
            this.cube.setSilent(true);
            this.ticker = new CloudTicker(this);
            this.data = new CustomBlockData(loc);
            this.tagBlock();
        }

        public void tagBlock() {
            this.data.set(BottledCloudItem.this.placedBlock, PersistentDataType.INTEGER, 1);
        }

        public void removeTag() {
            if (this.data.has(BottledCloudItem.this.placedBlock, PersistentDataType.INTEGER)) {
                this.data.remove(BottledCloudItem.this.placedBlock);
            }
        }

        public void initTicker() {
            this.ticker.runTaskTimer((Plugin)BottledCloudItem.this.getPlugin(), 0L, 20L);
        }
    }

    public class CloudTicker
    extends BukkitRunnable {
        private CloudEntity entity;
        private int count;

        public CloudTicker(CloudEntity entity) {
            this.entity = entity;
            this.count = 0;
        }

        public void removeAll() {
            this.entity.armorStand.remove();
            this.entity.cube.remove();
            this.entity.removeTag();
            this.cancel();
        }

        public void run() {
            if (this.count == 5) {
                this.removeAll();
                BottledCloudItem.this.clouds.remove(this.entity.loc);
                return;
            }
            if (this.entity.armorStand.isDead() || this.entity.cube.isDead()) {
                this.removeAll();
                BottledCloudItem.this.clouds.remove(this.entity.loc);
                return;
            }
            this.entity.loc.getWorld().spawnParticle(Particle.CLOUD, this.entity.armorStand.getEyeLocation().add(0.0, 0.7, 0.0), 4, 0.0, 0.0, 0.0, 0.01);
            ++this.count;
        }
    }
}

