/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.bettersignedit;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketListener;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.modules.bettersignedit.BSEFlag;
import com.github.sachin.tweakin.modules.bettersignedit.UpdateSignListener;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.persistence.PersistentDataType;

@Tweak(name="better-sign-edit")
public class BetterSignEditTweak
extends BaseTweak
implements Listener {
    public ProtocolManager manager;
    private UpdateSignListener listener;
    private BSEFlag flag;
    public final NamespacedKey key = Tweakin.getKey("sign-edited");
    public List<Player> lines = new ArrayList<Player>();

    @Override
    public void onLoad() {
        this.manager = ProtocolLibrary.getProtocolManager();
        this.listener = new UpdateSignListener(this.plugin, this);
        if (this.plugin.isWorldGuardEnabled) {
            this.flag = (BSEFlag)this.plugin.getWGFlagManager().getFlag("tweakin-better-sign-edit");
        }
    }

    @Override
    public void register() {
        super.register();
        this.manager.addPacketListener((PacketListener)this.listener);
    }

    @Override
    public void unregister() {
        super.unregister();
        this.manager.removePacketListener((PacketListener)this.listener);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onSignClick(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK || e.getHand() != EquipmentSlot.HAND || e.getItem() != null) {
            return;
        }
        Player player = e.getPlayer();
        if (!player.isSneaking()) {
            return;
        }
        if (!e.getClickedBlock().getType().toString().endsWith("_SIGN") || !this.hasPermission(player, Permissions.BETTERSIGNEDIT) || this.getBlackListWorlds().contains(player.getWorld().getName())) {
            return;
        }
        if (this.flag != null && !this.flag.queryFlag(player, e.getClickedBlock().getLocation())) {
            return;
        }
        Sign sign = (Sign)e.getClickedBlock().getState();
        sign.getPersistentDataContainer().set(this.key, PersistentDataType.STRING, (Object)"");
        sign.update(true);
        this.lines.add(player);
        PacketContainer packet = new PacketContainer(PacketType.Play.Server.OPEN_SIGN_EDITOR);
        packet.getBlockPositionModifier().write(0, (Object)new BlockPosition(e.getClickedBlock().getX(), e.getClickedBlock().getY(), e.getClickedBlock().getZ()));
        try {
            this.manager.sendServerPacket(player, packet);
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
    }
}

