/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.bettergrindstone;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.compat.AdvancedEnchantments;
import com.github.sachin.tweakin.compat.EnchantsSquaredCompat;
import com.github.sachin.tweakin.compat.ExcellentEnchantsCompat;
import com.github.sachin.tweakin.nbtapi.NBTItem;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.GrindstoneInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

@Tweak(name="better-grindstone")
public class BetterGrindStoneTweak
extends BaseTweak
implements Listener {
    private final NamespacedKey key = Tweakin.getKey("ignore-better-grindstone");

    @EventHandler
    public void onItemEnchant(EnchantItemEvent e) {
        if (this.getConfig().getBoolean("ignore-items-from-enchanting-table")) {
            ItemMeta meta = e.getItem().getItemMeta();
            meta.getPersistentDataContainer().set(this.key, PersistentDataType.INTEGER, (Object)1);
            e.getItem().setItemMeta(meta);
        }
    }

    @EventHandler
    public void onGrindStoneUse(InventoryClickEvent e) {
        if (e.getView().getTopInventory() instanceof GrindstoneInventory) {
            final GrindstoneInventory inv = (GrindstoneInventory)e.getView().getTopInventory();
            ItemStack cursor = e.getCursor();
            Player player = (Player)e.getWhoClicked();
            if (cursor != null && e.getSlot() == 1 && cursor.getType() == Material.BOOK && inv.getItem(1) == null) {
                e.setCancelled(true);
                cursor.setAmount(cursor.getAmount() - 1);
                inv.setItem(1, new ItemStack(Material.BOOK));
            }
            if (!this.hasPermission(player, Permissions.BETTER_GRINDSTONE)) {
                return;
            }
            new BukkitRunnable(){

                public void run() {
                    ItemStack weapon = inv.getItem(0);
                    ItemStack book = inv.getItem(1);
                    ItemStack result = inv.getItem(2);
                    if (weapon != null && book != null && result == null) {
                        if (weapon.getItemMeta().getPersistentDataContainer().has(BetterGrindStoneTweak.this.key, PersistentDataType.INTEGER) && BetterGrindStoneTweak.this.getConfig().getBoolean("ignore-items-from-enchanting-table")) {
                            return;
                        }
                        if (book.getType() == Material.BOOK && book.getAmount() == 1 && !weapon.getEnchantments().isEmpty() && weapon.getType() != Material.ENCHANTED_BOOK) {
                            NBTItem nbti = new NBTItem(weapon);
                            if (nbti.hasKey("armored-elytra")) {
                                return;
                            }
                            ItemStack enchantedBook = new ItemStack(Material.ENCHANTED_BOOK);
                            EnchantmentStorageMeta enchMeta = (EnchantmentStorageMeta)enchantedBook.getItemMeta();
                            for (Enchantment ench : weapon.getEnchantments().keySet()) {
                                enchMeta.addStoredEnchant(ench, weapon.getEnchantmentLevel(ench), false);
                                enchantedBook.setItemMeta((ItemMeta)enchMeta);
                            }
                            if (AdvancedEnchantments.isPluginEnabled) {
                                enchantedBook = AdvancedEnchantments.applyEnchantments(enchantedBook, weapon);
                            }
                            if (ExcellentEnchantsCompat.isEnabled) {
                                ExcellentEnchantsCompat.applyEnchantMents(enchantedBook, weapon);
                            }
                            if (EnchantsSquaredCompat.isEnabled) {
                                EnchantsSquaredCompat.applyEnchants(enchantedBook, weapon);
                            }
                            inv.setItem(2, enchantedBook);
                        }
                    }
                }
            }.runTaskLater((Plugin)this.plugin, 2L);
        }
    }
}

