/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.betterflee;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Tweakin;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.Arrays;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.persistence.PersistentDataType;

@Tweak(name="animal-flee")
public class AnimalFleeTweak
extends BaseTweak
implements Listener {
    public static final NamespacedKey key = Tweakin.getKey("animal-flee-flag");

    @EventHandler
    public void onAnimalDamage(EntityDamageByEntityEvent e) {
        if (e.getCause() == EntityDamageEvent.DamageCause.ENTITY_ATTACK || e.getCause() == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK) {
            if (this.containsWorld(e.getEntity().getWorld())) {
                return;
            }
            if (e.getDamager() instanceof Player) {
                Player player = (Player)e.getDamager();
                if (this.hasPermission(player, Permissions.FLEEMOBS)) {
                    return;
                }
                Entity attacked = e.getEntity();
                if (this.getConfig().getStringList("fleeable-mobs").contains(attacked.getType().toString())) {
                    if (attacked.getPersistentDataContainer().has(key, PersistentDataType.INTEGER) && this.getConfig().getBoolean("ignore-breeded")) {
                        return;
                    }
                    this.plugin.getNmsHelper().avoidPlayer(attacked, player, this.getConfig());
                }
            }
        }
    }

    @EventHandler
    public void onAnimalBreed(EntityBreedEvent e) {
        if (this.getConfig().getStringList("fleeable-mobs").contains(e.getEntityType().toString())) {
            for (LivingEntity l : Arrays.asList(e.getMother(), e.getFather(), e.getEntity())) {
                l.getPersistentDataContainer().set(key, PersistentDataType.INTEGER, (Object)1);
            }
        }
    }
}

