/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.betterbonemeal;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Config;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Dispenser;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

@Tweak(name="better-bone-meal")
public class BetterBoneMealTweak
extends BaseTweak
implements Listener {
    @Config(key="growable-blocks")
    private List<String> growableBlocks = new ArrayList<String>();
    @Config(key="dispenser-usable")
    private boolean dispenserUsable = true;
    @Config(key="growth-limit")
    private int growthLimit = 10;
    private boolean hasSugarCane;
    private boolean hasCactus;
    private boolean hasLilyPad;
    private boolean hasNetherWart;

    @Override
    public void reload() {
        super.reload();
        this.hasSugarCane = this.growableBlocks.contains("SUGARCANE");
        this.hasCactus = this.growableBlocks.contains("CACTUS");
        this.hasNetherWart = this.growableBlocks.contains("NETHERWART");
    }

    @EventHandler
    public void onDispenserDispenseBonemeal(BlockDispenseEvent e) {
        if (e.getBlock().getType() == Material.DISPENSER && e.getItem().getType() == Material.BONE_MEAL && this.dispenserUsable && !this.containsWorld(e.getBlock().getWorld())) {
            Directional directional = (Directional)e.getBlock().getBlockData();
            Block relative = e.getBlock().getRelative(directional.getFacing());
            boolean growed = this.applyBoneMeal(relative, e.getItem(), null);
            if (growed) {
                final ItemStack item = e.getItem().clone();
                Dispenser dispenser = (Dispenser)e.getBlock().getState();
                final int slot = dispenser.getInventory().first(item);
                item.setAmount(item.getAmount() - 1);
                final Inventory inv = dispenser.getInventory();
                Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        inv.setItem(slot, item);
                    }
                }, 1L);
            }
        }
    }

    @EventHandler
    public void onUseBoneMeal(PlayerInteractEvent e) {
        if (e.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = e.getClickedBlock();
        ItemStack item = e.getItem();
        Player player = e.getPlayer();
        if (item != null && item.getType() == Material.BONE_MEAL) {
            if (this.plugin.griefCompat != null && !this.plugin.griefCompat.canBuild(player, block.getLocation(), item.getType()) || !this.hasPermission(player, Permissions.BETTER_BONEMEAL) || this.containsWorld(player.getWorld())) {
                return;
            }
            boolean growed = this.applyBoneMeal(block, item, player);
            if (growed) {
                if (player.getGameMode() != GameMode.CREATIVE) {
                    item.setAmount(item.getAmount() - 1);
                }
                if (e.getHand() == EquipmentSlot.HAND) {
                    player.swingMainHand();
                } else {
                    player.swingOffHand();
                }
            }
        }
    }

    private boolean applyBoneMeal(Block block, ItemStack item, @Nullable Player player) {
        Block baseBlock = this.getTopBlock(block);
        Block topperBlock = this.isGrowable(baseBlock);
        int height = this.getHeightFromDown(baseBlock, 0);
        if (this.growthLimit == height + 1) {
            return false;
        }
        if (topperBlock != null) {
            Ageable ageable;
            if (block.getType() == Material.SUGAR_CANE && this.hasSugarCane) {
                topperBlock.setType(Material.SUGAR_CANE);
                this.playBoneMealEffect(block);
                return true;
            }
            if (block.getType() == Material.CACTUS && this.hasCactus) {
                topperBlock.setType(Material.CACTUS);
                this.playBoneMealEffect(block);
                return true;
            }
            if (block.getType() == Material.NETHER_WART && this.hasNetherWart && (ageable = (Ageable)block.getBlockData()).getAge() < ageable.getMaximumAge()) {
                ageable.setAge(ageable.getAge() + 1);
                block.setBlockData((BlockData)ageable);
                this.playBoneMealEffect(block);
                return true;
            }
        }
        return false;
    }

    private List<Block> getNearbyBlocks(Block block) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        int x = block.getX() - 3;
        while (x <= block.getX() + 3) {
            int z = block.getZ() - 3;
            while (z <= block.getZ() + 3) {
                Block target = block.getWorld().getBlockAt(x, block.getY(), z);
                if (target.getRelative(BlockFace.DOWN).getType() == Material.WATER && (target.getType() == Material.AIR || target.getType() == Material.CAVE_AIR)) {
                    blocks.add(target);
                }
                ++z;
            }
            ++x;
        }
        return blocks;
    }

    private int getHeightFromDown(Block block, int fromDown) {
        Block blockBelow = block.getRelative(BlockFace.DOWN);
        if (blockBelow.getType() == block.getType()) {
            return this.getHeightFromDown(blockBelow, ++fromDown);
        }
        return fromDown;
    }

    private void playBoneMealEffect(Block block) {
        block.getWorld().playEffect(block.getLocation(), Effect.BONE_MEAL_USE, 0);
    }

    private Block getTopBlock(Block block) {
        Block upperBlock = block.getRelative(BlockFace.UP);
        if (upperBlock.getType() == block.getType()) {
            return this.getTopBlock(upperBlock);
        }
        return block;
    }

    private Block isGrowable(Block block) {
        Block topperBlock = block.getRelative(BlockFace.UP);
        if (topperBlock.getType() == Material.AIR || topperBlock.getType() == Material.CAVE_AIR) {
            return topperBlock;
        }
        return null;
    }
}

