/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin.modules.autorecipeunlock;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.utils.Permissions;
import com.github.sachin.tweakin.utils.annotations.Tweak;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

@Tweak(name="auto-recipe-unlock")
public class AutoRecipeUnlockTweak
extends BaseTweak
implements Listener {
    private List<NamespacedKey> recipes = new ArrayList<NamespacedKey>();

    @Override
    public void register() {
        super.register();
        this.loadRecipes();
        Bukkit.getOnlinePlayers().forEach(p -> this.discoverRecipes((Player)p));
    }

    @Override
    public void unregister() {
        super.unregister();
        this.recipes.clear();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent e) {
        this.discoverRecipes(e.getPlayer());
    }

    public void loadRecipes() {
        Bukkit.recipeIterator().forEachRemaining(recipe -> {
            if (recipe instanceof Keyed) {
                this.recipes.add(((Keyed)recipe).getKey());
            }
        });
    }

    public void discoverRecipes(Player player) {
        if (this.hasPermission(player, Permissions.AUTORECIPEUNLOCK)) {
            for (NamespacedKey namespacedKey : this.recipes) {
                if (player.hasDiscoveredRecipe(namespacedKey)) continue;
                player.discoverRecipe(namespacedKey);
            }
        }
    }
}

