/*
 * Decompiled with CFR 0.152.
 */
package com.github.sachin.tweakin;

import com.github.sachin.tweakin.BaseTweak;
import com.github.sachin.tweakin.Message;
import com.github.sachin.tweakin.WGFlagManager;
import com.github.sachin.tweakin.acf.CommandReplacements;
import com.github.sachin.tweakin.acf.PaperCommandManager;
import com.github.sachin.tweakin.bstats.Metrics;
import com.github.sachin.tweakin.commands.CoreCommand;
import com.github.sachin.tweakin.compat.CombatLogXCompat;
import com.github.sachin.tweakin.compat.VulcanListenerCompat;
import com.github.sachin.tweakin.compat.grief.BaseGriefCompat;
import com.github.sachin.tweakin.compat.grief.CrashClaimCompat;
import com.github.sachin.tweakin.compat.grief.GriefPreventionCompat;
import com.github.sachin.tweakin.compat.grief.LandsCompat;
import com.github.sachin.tweakin.compat.grief.ResidenceCompat;
import com.github.sachin.tweakin.compat.grief.TownyCompat;
import com.github.sachin.tweakin.gui.GuiListener;
import com.github.sachin.tweakin.manager.TweakManager;
import com.github.sachin.tweakin.modules.lapisintable.LapisData;
import com.github.sachin.tweakin.modules.mobheads.Head;
import com.github.sachin.tweakin.modules.morerecipes.MoreRecipesTweak;
import com.github.sachin.tweakin.nbtapi.NBTAPI;
import com.github.sachin.tweakin.nbtapi.nms.NMSHelper;
import com.github.sachin.tweakin.utils.MiscItems;
import com.github.sachin.tweakin.utils.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permission;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Tweakin
extends JavaPlugin {
    private static Tweakin plugin;
    private Metrics metrics;
    public final Random RANDOM = new Random();
    public boolean isRunningPaper;
    private WGFlagManager wgFlagManager;
    public boolean isWorldGuardEnabled;
    private String version;
    private String mcVersion;
    private PaperCommandManager commandManager;
    public BaseGriefCompat griefCompat;
    public CommandReplacements replacements;
    private TweakManager tweakManager;
    private Message messageManager;
    private NMSHelper nmsHelper;
    private boolean isEnabled;
    public boolean isProtocolLibEnabled;
    public boolean isFirstInstall;
    private MiscItems miscItems;
    public final Map<String, Integer> placedBlocksMap = new HashMap<String, Integer>();
    private List<Permission> permissions;
    private List<Player> placedPlayers = new ArrayList<Player>();

    public void onLoad() {
        plugin = this;
        boolean bl = this.isWorldGuardEnabled = Bukkit.getPluginManager().getPlugin("WorldGuard") != null;
        if (this.isWorldGuardEnabled) {
            this.wgFlagManager = new WGFlagManager(this);
            plugin.getLogger().info("Found WorldGuard, initializing flags support");
            this.wgFlagManager.registerFlags();
        }
    }

    public void onEnable() {
        this.isEnabled = true;
        this.isFirstInstall = false;
        try {
            Class.forName("com.destroystokyo.paper.utils.PaperPluginLogger");
            this.isRunningPaper = true;
            this.getLogger().info("Running papermc..");
        }
        catch (ClassNotFoundException e) {
            this.isRunningPaper = false;
        }
        this.registerGriefCompat();
        if (this.isPluginEnabled("Vulcan")) {
            new VulcanListenerCompat().registerEvents();
            this.getLogger().info("Running Vulcan, registering listener for reacharound");
        }
        if (this.isPluginEnabled("CombatLogX")) {
            new CombatLogXCompat().registerEvents();
            this.getLogger().info("Running CombatLogX, registering listener for better-ladders");
        }
        int currentMajor = Integer.parseInt(Bukkit.getBukkitVersion().split("\\.")[0]);
        int currentMinor = Integer.parseInt(Bukkit.getBukkitVersion().split("\\.")[1].split("-")[0]);
        int currentPatch = Bukkit.getBukkitVersion().chars().filter(ch -> ch == 46).count() == 2L ? 0 : Integer.parseInt(Bukkit.getBukkitVersion().split("\\.")[2].split("-")[0]);
        this.mcVersion = String.valueOf(currentMajor) + "." + currentMinor;
        if (currentPatch > 0) {
            this.mcVersion = String.valueOf(this.mcVersion) + "." + currentPatch;
        }
        this.version = plugin.getServer().getClass().getPackage().getName().split("\\.")[3];
        this.getLogger().info("Running " + this.mcVersion + " minecraft version...");
        NBTAPI nbtapi = new NBTAPI();
        if (!nbtapi.loadVersions(this, this.version, this.mcVersion)) {
            this.getLogger().warning("Running incompataible minecraft version, stopping tweakin");
            this.isEnabled = false;
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.reloadMiscItems();
        this.reloadMessageManager();
        this.getServer().getPluginManager().registerEvents((Listener)new GuiListener(plugin), (Plugin)plugin);
        this.isProtocolLibEnabled = plugin.getServer().getPluginManager().isPluginEnabled("ProtocolLib");
        this.nmsHelper = nbtapi.getNMSHelper();
        this.saveDefaultConfig();
        this.reloadConfig();
        this.commandManager = new PaperCommandManager((Plugin)this);
        this.replacements = this.commandManager.getCommandReplacements();
        this.tweakManager = new TweakManager(this);
        this.tweakManager.load();
        Permissions.reload();
        Tweakin.getPlugin().getLogger().info("Registering permissions");
        this.permissions = Arrays.asList(Permissions.BETTERRECOVERYCOMPASS_USE, Permissions.ARMOREDELYTRA_CRAFT, Permissions.AUTORECIPEUNLOCK, Permissions.BETTERARMORSTAND_PARENT, Permissions.BETTERARMORSTAND_COMMAND, Permissions.BETTERARMORSTAND_UUIDBYPASS, Permissions.BETTERARMORSTAND_ARMORSWAP, Permissions.ARMORSTANDWAND, Permissions.FLEEMOBS, Permissions.BETTER_GRINDSTONE, Permissions.BETTERLADDER_PARENT, Permissions.BETTERLADDER_QUICKCLIMB, Permissions.BETTERLADDER_DROPDOWN, Permissions.BETTERSIGNEDIT, Permissions.BOTTLED_CLOUD_PARENT, Permissions.BOTTLEDCLOUD_USE, Permissions.BOTTLEDCLOUD_PICKUP, Permissions.BURNVINETIP_USE, Permissions.COMPASSTRACK, Permissions.HUD_PARENT, Permissions.HUD_COMPASSBYPASS, Permissions.HUD_COMMAND, Permissions.CRAFTINGTABLE_USE, Permissions.CUSTOMPORTAL_USE, Permissions.INFIFIREWORK_USE, Permissions.INFBUCKET_PARENT, Permissions.INFIBUCKET_CRAFT, Permissions.INFIBUCKET_USE, Permissions.LAVATRASHCAN, Permissions.MOBHEADS, Permissions.NETHERCOORDS, Permissions.PAT_DOG, Permissions.PAT_CAT, Permissions.POISONPOTATO, Permissions.REACHAROUND_PARENT, Permissions.REACHAROUND_HIGHLIGHT, Permissions.REACHAROUND_VERT, Permissions.REACHAROUND_HORI, Permissions.REACHAROUND_TOGGLE, Permissions.ARMORCLICK, Permissions.SHULKERBOX_CLICK, Permissions.ENDERCHEST_CLICK, Permissions.ROTATION_WRENCH, Permissions.SHEARITEMFRAME, Permissions.SHEARNAMETAG, Permissions.SILENCEMOBS_PARENT, Permissions.SILENCEMOBS_SILENCE, Permissions.SILENCEMOBS_UNSILENCE, Permissions.SLIMEBUCKET_PARENT, Permissions.SLIMEBUCKET_PICKUP, Permissions.SLIMEBUCKET_DETECT, Permissions.SWINGGRASS, Permissions.TROWEL, Permissions.VIL_DTH_MSG, Permissions.ANVIL_REPAIR, Permissions.WATER_EX, Permissions.BETTER_BONEMEAL, Permissions.JUMPYBOATS, Permissions.CAULDRON_CONCRETE, Permissions.CHICKEN_SHEARING);
        for (Permission perm : this.permissions) {
            if (perm == null) continue;
            Bukkit.getServer().getPluginManager().addPermission(perm);
        }
        Tweakin.getPlugin().getLogger().info("Registered " + this.permissions.size() + " permissions");
        ConfigurationSerialization.registerClass(LapisData.class, (String)"LapisData");
        this.commandManager.getCommandCompletions().registerCompletion("tweakitems", c -> this.tweakManager.getRegisteredItemNames());
        this.commandManager.getCommandCompletions().registerCompletion("tweaklist", c -> this.tweakManager.getTweakNames());
        List headList = Arrays.asList(Head.values()).stream().map(h -> h.toString()).collect(Collectors.toList());
        this.commandManager.getCommandCompletions().registerCompletion("tweakinheads", c -> headList);
        this.commandManager.registerCommand(new CoreCommand(this));
        this.enabledBstats();
        this.getLogger().info("Tweakin loaded successfully");
    }

    public MiscItems getMiscItems() {
        return this.miscItems;
    }

    public void reloadMiscItems() {
        this.miscItems = new MiscItems(this);
    }

    public void reloadMessageManager() {
        this.messageManager = new Message(plugin);
        this.messageManager.reload();
    }

    public void onDisable() {
        if (!this.isEnabled) {
            return;
        }
        for (Permission perm : this.permissions) {
            if (perm == null) continue;
            Bukkit.getServer().getPluginManager().removePermission(perm);
        }
        for (BaseTweak t : this.tweakManager.getTweakList()) {
            if (!t.registered) continue;
            t.onDisable();
        }
        if (this.metrics != null) {
            this.metrics.addCustomChart(new Metrics.AdvancedPie("Placed-Blocks", new Callable<Map<String, Integer>>(){

                @Override
                public Map<String, Integer> call() throws Exception {
                    return Tweakin.this.placedBlocksMap;
                }
            }));
        }
    }

    private void registerGriefCompat() {
        if (!this.getConfig().getBoolean("grief-plugin-support")) {
            return;
        }
        if (this.isPluginEnabled("GriefPrevention")) {
            this.griefCompat = new GriefPreventionCompat();
        } else if (this.isPluginEnabled("Lands")) {
            this.griefCompat = new LandsCompat();
        } else if (this.isPluginEnabled("Residence")) {
            this.griefCompat = new ResidenceCompat();
        } else if (this.isPluginEnabled("CrashClaim")) {
            this.griefCompat = new CrashClaimCompat();
        } else if (this.isPluginEnabled("Towny")) {
            this.griefCompat = new TownyCompat();
        }
    }

    public boolean isPluginEnabled(String name) {
        return this.getServer().getPluginManager().isPluginEnabled(name);
    }

    public String getVersion() {
        return this.version;
    }

    private void enabledBstats() {
        if (this.getConfig().getBoolean("metrics", true)) {
            this.metrics = new Metrics(this, 11786);
            this.getLogger().info("Enabling bstats...");
            this.metrics.addCustomChart(new Metrics.AdvancedPie("Enabled-Tweaks", new Callable<Map<String, Integer>>(){

                @Override
                public Map<String, Integer> call() throws Exception {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    for (BaseTweak tweak : Tweakin.this.getTweakManager().getTweakList()) {
                        if (!tweak.shouldEnable()) continue;
                        map.put(tweak.getName(), 1);
                    }
                    return map;
                }
            }));
            ((MoreRecipesTweak)this.tweakManager.getTweakFromName("more-recipes")).addBstatsGraph(this.metrics);
        }
    }

    public void addPlacedPlayer(Player player) {
        this.placedPlayers.add(player);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> this.placedPlayers.remove(player), 3L);
    }

    public boolean isPost1_17() {
        return Arrays.asList("v1_17_R1", "v1_18_R1", "v1_18_R2", "v1_19_R1", "v1_19_R2", "v1_19_R3").contains(this.version);
    }

    public boolean isPost1_18() {
        return Arrays.asList("v1_18_R1", "v1_18_R2", "v1_19_R1", "v1_19_R2", "v1_19_R3").contains(this.version);
    }

    public boolean isPost1_19() {
        return Arrays.asList("v1_19_R1", "v1_19_R2", "v1_19_R3").contains(this.version);
    }

    public boolean isPost1_19_3() {
        return Arrays.asList("v1_19_R3").contains(this.version);
    }

    public List<Player> getPlacedPlayers() {
        return this.placedPlayers;
    }

    public NMSHelper getNmsHelper() {
        return this.nmsHelper;
    }

    public static Tweakin getPlugin() {
        return plugin;
    }

    public PaperCommandManager getCommandManager() {
        return this.commandManager;
    }

    public TweakManager getTweakManager() {
        return this.tweakManager;
    }

    public Message getMessageManager() {
        return this.messageManager;
    }

    public static NamespacedKey getKey(String key) {
        return new NamespacedKey((Plugin)plugin, key);
    }

    public WGFlagManager getWGFlagManager() {
        return this.wgFlagManager;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }
}

