/*
 * Decompiled with CFR 0.152.
 */
package be.isach.turfwars.util;

import be.isach.turfwars.core.TurfWars;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.bukkit.entity.Player;

public class SQLUtils {
    private TurfWars plugin;

    public SQLUtils(TurfWars plugin) {
        this.plugin = plugin;
    }

    public void initStats(Player p) {
        try {
            this.plugin.log.info("Turf Wars >>> Checking stats existence for player " + p.getName());
            if (!this.plugin.table.select().where("uuid", p.getUniqueId().toString()).execute().next()) {
                this.plugin.log.info("Turf Wars >>> No stats found for player " + p.getName() + ". Initialising player stats...");
                this.plugin.table.insert().insert("uuid").value(p.getUniqueId().toString()).execute();
                this.plugin.table.update().set("username", p.getName()).where("uuid", p.getUniqueId().toString()).execute();
                this.plugin.log.info("Turf Wars >>> Stats for player " + p.getName() + " successfully initialized.");
            } else {
                ResultSet res = this.plugin.table.select().where("uuid", p.getUniqueId().toString()).execute();
                res.first();
                String s = res.getString("username");
                if (s == null) {
                    this.plugin.table.update().set("username", p.getName()).where("uuid", p.getUniqueId().toString()).execute();
                    return;
                }
                if (!s.equals(p.getName())) {
                    this.plugin.table.update().set("username", p.getName()).where("uuid", p.getUniqueId().toString()).execute();
                }
            }
        }
        catch (Exception e) {
            this.plugin.log.severe("Could not initialize stats for player " + p.getCustomName() + ". MySQL Error");
            e.printStackTrace();
        }
    }

    public int getTotalKills(UUID playerId) {
        try {
            ResultSet res = this.plugin.table.select().where("uuid", playerId.toString()).execute();
            res.first();
            return res.getInt("kills");
        }
        catch (SQLException e) {
            this.plugin.log.severe("Turf Wars >>> Error during getting kills amount for player " + playerId);
            return 0;
        }
    }

    public int getWins(UUID playerId) {
        try {
            ResultSet res = this.plugin.table.select().where("uuid", playerId.toString()).execute();
            res.first();
            return res.getInt("wins");
        }
        catch (SQLException e) {
            this.plugin.log.severe("Turf Wars >>> Error during getting wins amount for player " + playerId);
            return 0;
        }
    }

    public int getLosses(UUID playerId) {
        try {
            ResultSet res = this.plugin.table.select().where("uuid", playerId.toString()).execute();
            res.first();
            return res.getInt("losses");
        }
        catch (SQLException e) {
            this.plugin.log.severe("Turf Wars >>> Error during getting losses amount for player " + playerId);
            return 0;
        }
    }

    public boolean hasUnlockedShredder(UUID id) {
        try {
            ResultSet res = this.plugin.table.select().where("uuid", id.toString()).execute();
            res.first();
            return res.getBoolean("shredderUnlocked");
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean hasUnlockedInfiltrator(UUID id) {
        try {
            ResultSet res = this.plugin.table.select().where("uuid", id.toString()).execute();
            res.first();
            return res.getBoolean("infiltratorUnlocked");
        }
        catch (SQLException e) {
            return false;
        }
    }

    public int getMoney(UUID uuid) {
        try {
            ResultSet res = this.plugin.table.select().where("uuid", uuid.toString()).execute();
            res.first();
            return res.getInt("money");
        }
        catch (SQLException e) {
            this.plugin.log.severe("Turf Wars >>> Error during getting kills amount for player with id " + uuid);
            return 0;
        }
    }
}

