/*
 * Decompiled with CFR 0.152.
 */
package be.isach.turfwars.core;

import be.isach.turfwars.TurfWarsAPI;
import be.isach.turfwars.listener.PlayerListener;
import be.isach.turfwars.util.CustomConfiguration;
import be.isach.turfwars.util.FileUtils;
import be.isach.turfwars.util.SQLUtils;
import be.isach.turfwars.util.mysql.MySQLConnection;
import be.isach.turfwars.util.mysql.Table;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class TurfWars
extends JavaPlugin {
    private static TurfWarsAPI api;
    private boolean connected;
    private MoneySystem moneySystem;
    public Connection co;
    public Table table;
    private MySQLConnection sql;
    public Logger log;
    public static SQLUtils sqlUtils;
    public Economy economy;
    public static CustomConfiguration config;
    public static File file;

    public void onEnable() {
        this.log("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=");
        this.log("");
        this.loadConfig();
        this.log("");
        this.startMySQLRunnable();
        this.log("Trying to set up Economy...");
        boolean b = this.setupEconomy();
        if (b) {
            this.log("Vault loaded and hooked.");
        } else {
            this.log("Vault not loaded, if you're using vault for money, it's important, install it, else, it doesn't matter.");
        }
        this.log("");
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.log("-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=");
        api = new TurfWarsAPI(this);
    }

    private void log(Object o) {
        System.out.println("TurfWars Add-on -> " + o.toString());
    }

    private void loadConfig() {
        String s;
        this.log("Loading configuration...");
        file = new File(this.getDataFolder(), "config.yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            FileUtils.copy(this.getResource("config.yml"), file);
            this.log("Config file doesn't exist yet.");
            this.log("Creating Config File and loading it.");
        }
        this.moneySystem = (s = (config = CustomConfiguration.loadConfiguration(file)).getString("money-system")).toLowerCase().startsWith("m") ? MoneySystem.MYSQL : MoneySystem.VAULT;
    }

    private void startMySQLRunnable() {
        sqlUtils = new SQLUtils(this);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, new Runnable(){

            @Override
            public void run() {
                try {
                    ResultSet rs2;
                    String hostname = TurfWars.this.getInfo("hostname");
                    String username = TurfWars.this.getInfo("username");
                    String password = TurfWars.this.getInfo("password");
                    String port = TurfWars.this.getInfo("port");
                    String database = TurfWars.this.getInfo("database");
                    TurfWars.this.sql = new MySQLConnection(hostname, port, database, username, password);
                    TurfWars.this.co = TurfWars.this.sql.getConnection();
                    Bukkit.getLogger().info("");
                    Bukkit.getConsoleSender().sendMessage("\u00a7b\u00a7lTurf Wars >>> Successfully connected to MySQL server!");
                    Bukkit.getLogger().info("");
                    PreparedStatement sql = TurfWars.this.co.prepareStatement("CREATE TABLE IF NOT EXISTS TurfWarsStats(id INTEGER not NULL AUTO_INCREMENT, uuid VARCHAR(255), username VARCHAR(255), kills INTEGER DEFAULT 0 not NULL, money INTEGER DEFAULT 0 not NULL, infiltratorUnlocked INTEGER DEFAULT 0 not NULL, shredderUnlocked INTEGER DEFAULT 0 not NULL, PRIMARY KEY ( id ))");
                    sql.executeUpdate();
                    TurfWars.this.table = new Table(TurfWars.this.co, "TurfWarsStats");
                    DatabaseMetaData md = TurfWars.this.co.getMetaData();
                    ResultSet rs = md.getColumns(null, null, "TurfWarsStats", "wins");
                    if (!rs.next()) {
                        PreparedStatement statement = TurfWars.this.co.prepareStatement("ALTER TABLE TurfWarsStats ADD wins INTEGER DEFAULT 0 NOT NULL");
                        statement.executeUpdate();
                    }
                    if (!(rs2 = md.getColumns(null, null, "TurfWarsStats", "losses")).next()) {
                        PreparedStatement statement = TurfWars.this.co.prepareStatement("ALTER TABLE TurfWarsStats ADD losses INTEGER DEFAULT 0 NOT NULL");
                        statement.executeUpdate();
                    }
                    try {
                        TurfWars.this.connected = !TurfWars.this.co.isClosed();
                    }
                    catch (SQLException e) {
                        TurfWars.this.connected = false;
                    }
                }
                catch (Exception e) {
                    TurfWars.this.log("");
                    TurfWars.this.log("Could not connect to MySQL server!");
                    TurfWars.this.log("");
                    TurfWars.this.log("Error:");
                    e.printStackTrace();
                    TurfWars.this.log("");
                }
            }
        }, 0L, 24000L);
        this.log("");
    }

    private String getInfo(String s) {
        return config.getString("MySQL." + s);
    }

    public int getKills(UUID uuid) {
        if (this.connected) {
            return sqlUtils.getTotalKills(uuid);
        }
        return 0;
    }

    public int getWins(UUID uuid) {
        if (this.connected) {
            return sqlUtils.getWins(uuid);
        }
        return 0;
    }

    public int getLosses(UUID uuid) {
        if (this.connected) {
            return sqlUtils.getLosses(uuid);
        }
        return 0;
    }

    public double getMoney(UUID uuid) {
        if (this.moneySystem == MoneySystem.MYSQL && this.connected) {
            return sqlUtils.getMoney(uuid);
        }
        if (this.moneySystem == MoneySystem.VAULT || !this.connected) {
            return this.economy.getBalance(Bukkit.getOfflinePlayer((UUID)uuid));
        }
        return 0.0;
    }

    public boolean hasInfiltratorKit(UUID uuid) {
        if (this.connected) {
            return sqlUtils.hasUnlockedInfiltrator(uuid);
        }
        return false;
    }

    public boolean hasShredderKit(UUID uuid) {
        if (this.connected) {
            return sqlUtils.hasUnlockedShredder(uuid);
        }
        return false;
    }

    public static TurfWarsAPI getAPI() {
        return api;
    }

    private boolean setupEconomy() {
        RegisteredServiceProvider economyProvider = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (economyProvider != null) {
            this.economy = (Economy)economyProvider.getProvider();
        }
        return this.economy != null;
    }

    private static enum MoneySystem {
        MYSQL,
        VAULT;

    }
}

