/*
 * Decompiled with CFR 0.152.
 */
package com.thetruecolonel.truecustomdrops.listeners;

import com.thetruecolonel.truecustomdrops.BuildConfigurations;
import com.thetruecolonel.truecustomdrops.TrueCustomDropsSpigot;
import com.thetruecolonel.truecustomdrops.interfaces.IListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MobListener
implements Listener,
IListener {
    private boolean defaultDrops;
    private String path = "mobs.";
    private String entity;
    private String drop;
    private List<ItemStack> drops = new ArrayList<ItemStack>();
    private final String pathDefault = "mobs.";
    private static BuildConfigurations config;
    private static Economy economy;
    private static LivingEntity en;
    private static EntityDeathEvent e;
    private static Player p;

    public MobListener(Economy e) {
        config = BuildConfigurations.getMobConfig();
        economy = e;
    }

    @EventHandler(priority=EventPriority.LOW)
    void onEntityDeath(EntityDeathEvent event) {
        block4: {
            if (!(event.getEntity().getKiller() instanceof Player)) break block4;
            e = event;
            en = e.getEntity();
            p = en.getKiller();
            if (p.getGameMode() == GameMode.CREATIVE) {
                return;
            }
            Iterator iterator = config.getConfigurationSection("mobs").getKeys(false).iterator();
            if (iterator.hasNext()) {
                String entity;
                this.entity = entity = (String)iterator.next();
                this.path = "mobs.";
                this.path = this.path + entity;
                this.defaultDrops = config.getBoolean(this.path + ".defaultDrops", true);
                if (en.getType().name().equals("SLIME") || en.getType().name().equals("MAGMA_CUBE")) {
                    this.slimeCheck();
                } else {
                    this.checkPrelims();
                }
            }
        }
    }

    void slimeCheck() {
        if (en.getType().name().equals("SLIME")) {
            if (((Slime)en).getSize() == config.getInt(this.path + ".size")) {
                this.checkPrelims();
            }
        } else if (en.getType().toString().equals("MAGMA_CUBE") && ((MagmaCube)en).getSize() == config.getInt(this.path + ".size")) {
            this.checkPrelims();
        }
    }

    void checkPrelims() {
        if (en.getType().toString().equals(this.entity)) {
            if (config.isSet(this.path + ".requiredTools")) {
                for (Integer id : config.getIntegerList(this.path + ".requiredTools")) {
                    if (p.getEquipment().getItemInMainHand().getTypeId() != id.intValue()) continue;
                    this.checkPlayer();
                    break;
                }
            } else {
                this.checkPlayer();
            }
        }
    }

    @Override
    public void checkPlayer() {
        Iterator iterator = config.getConfigurationSection(this.path + ".drops").getKeys(false).iterator();
        block0: while (iterator.hasNext()) {
            String drop;
            this.drop = drop = (String)iterator.next();
            this.path = "mobs." + this.entity + ".drops." + drop;
            if (config.isSet(this.path + ".classes")) {
                for (String perm : config.getStringList(this.path + ".classes")) {
                    if (!p.hasPermission("truecustomdrops.class." + perm) && !p.isOp()) continue;
                    this.checkDrop();
                    break block0;
                }
                continue;
            }
            this.checkDrop();
            break;
        }
    }

    @Override
    public void checkDrop() {
        this.path = "mobs." + this.entity + ".drops." + this.drop;
        if (config.isSet(this.path + ".id") && config.isSet(this.path + ".money")) {
            this.dropItem();
            if (TrueCustomDropsSpigot.useVault.booleanValue()) {
                this.dropMoney();
            }
        } else if (config.isSet(this.path + ".id")) {
            this.dropItem();
        } else if (config.isSet(this.path + ".money") && TrueCustomDropsSpigot.useVault.booleanValue()) {
            this.dropMoney();
        }
    }

    @Override
    public void dropItem() {
        this.path = "mobs." + this.entity + ".drops." + this.drop;
        this.drops.clear();
        if (!this.defaultDrops) {
            e.getDrops().clear();
        }
        if (config.isSet(this.path + ".chance")) {
            if (this.randomChance(config.getDouble(this.path + ".chance"))) {
                this.drops.add(this.createItem());
                e.getDrops().addAll(this.drops);
            }
        } else {
            this.drops.add(this.createItem());
            e.getDrops().addAll(this.drops);
        }
        this.path = "mobs.";
    }

    @Override
    public void dropMoney() {
        this.path = "mobs." + this.entity + ".drops." + this.drop + ".money";
        if (config.isSet(this.path + ".chance")) {
            if (this.randomChance(config.getDouble(this.path + ".chance"))) {
                EconomyResponse r = economy.depositPlayer((OfflinePlayer)p, config.getDouble(this.path + ".value"));
                if (r.transactionSuccess()) {
                    p.sendMessage(ChatColor.GREEN + String.format("Lucky you! %s has been added to your account!", economy.format(r.amount)));
                } else {
                    p.sendMessage(ChatColor.RED + String.format("An error occured: %s", r.errorMessage));
                }
            }
        } else {
            EconomyResponse r = economy.depositPlayer((OfflinePlayer)p, config.getDouble(this.path + ".value"));
            if (r.transactionSuccess()) {
                p.sendMessage(ChatColor.GREEN + String.format("%s has been added to your account!", economy.format(r.amount)));
            } else {
                p.sendMessage(ChatColor.RED + String.format("An error occured: %s", r.errorMessage));
            }
        }
        this.path = "mobs.";
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(config.getInt(this.path + ".id"));
        if (config.isSet(this.path + ".meta")) {
            ItemMeta meta = item.getItemMeta();
            String metaPath = this.path + ".meta";
            if (config.isSet(metaPath + ".name")) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString(metaPath + ".name")));
            }
            if (config.isSet(metaPath + ".lore")) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String line : config.getStringList(metaPath + ".lore")) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
                meta.setLore(lore);
            }
            if (config.isSet(metaPath + ".enchants")) {
                String enchantPath = metaPath + ".enchants";
                for (String enchant : config.getConfigurationSection(enchantPath).getKeys(false)) {
                    meta.addEnchant(Enchantment.getById((int)config.getInt(enchantPath + "." + enchant + ".id")), config.getInt(enchantPath + "." + enchant + ".level"), true);
                }
            }
            item.setItemMeta(meta);
        }
        if (config.isSet(this.path + ".amount")) {
            item.setAmount(config.getInt(this.path + ".amount"));
        } else if (config.isSet(this.path + ".min") && config.isSet(this.path + ".max")) {
            item.setAmount(this.randomInt(config.getInt(this.path + ".min"), config.getInt(this.path + ".max")));
        }
        return item;
    }
}

