/*
 * Decompiled with CFR 0.152.
 */
package com.thetruecolonel.truecustomdrops.listeners;

import com.thetruecolonel.truecustomdrops.BuildConfigurations;
import com.thetruecolonel.truecustomdrops.TrueCustomDropsSpigot;
import com.thetruecolonel.truecustomdrops.interfaces.IListener;
import java.util.ArrayList;
import java.util.Iterator;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BlockListener
implements Listener,
IListener {
    private boolean defaultDrops;
    private String path = "blocks.";
    private String worldBlock;
    private String drop;
    private final String pathDefault = "blocks.";
    private static BuildConfigurations config;
    private static Economy economy;
    private static Block b;
    private static BlockBreakEvent e;
    private static Player p;

    public BlockListener(Economy e) {
        config = BuildConfigurations.getBlockConfig();
        economy = e;
    }

    @EventHandler(priority=EventPriority.LOW)
    void onBlockBreak(BlockBreakEvent event) {
        e = event;
        p = e.getPlayer();
        b = e.getBlock();
        if (p.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Iterator iterator = config.getConfigurationSection("blocks").getKeys(false).iterator();
        block0: while (iterator.hasNext()) {
            String worldBlock;
            this.worldBlock = worldBlock = (String)iterator.next();
            this.path = "blocks.";
            this.path = this.path + worldBlock;
            if (b.getTypeId() != config.getInt(this.path + ".id") || b.getData() != config.getInt(this.path + ".dataID")) continue;
            this.defaultDrops = config.getBoolean(this.path + ".defaultDrops", true);
            if (config.isSet(this.path + ".requiredTools")) {
                for (Integer id : config.getIntegerList(this.path + ".requiredTools")) {
                    if (p.getEquipment().getItemInMainHand().getTypeId() != id.intValue()) continue;
                    this.checkPlayer();
                    continue block0;
                }
                continue;
            }
            this.checkPlayer();
            break;
        }
    }

    @Override
    public void checkPlayer() {
        Iterator iterator = config.getConfigurationSection(this.path + ".drops").getKeys(false).iterator();
        block0: while (iterator.hasNext()) {
            String drop;
            this.drop = drop = (String)iterator.next();
            this.path = "blocks." + this.worldBlock + ".drops." + drop;
            if (config.isSet(this.path + ".classes")) {
                for (String perm : config.getStringList(this.path + ".classes")) {
                    if (!p.hasPermission("truecustomdrops.class." + perm) && !p.isOp()) continue;
                    this.checkDrop();
                    break block0;
                }
                continue;
            }
            this.checkDrop();
            break;
        }
    }

    @Override
    public void checkDrop() {
        this.path = "blocks." + this.worldBlock + ".drops." + this.drop;
        if (config.isSet(this.path + ".id") && config.isSet(this.path + ".money")) {
            this.dropItem();
            if (TrueCustomDropsSpigot.useVault.booleanValue()) {
                this.dropMoney();
            }
        } else if (config.isSet(this.path + ".id") && !config.isSet(this.path + ".money")) {
            this.dropItem();
        } else if (config.isSet(this.path + ".money") && !config.isSet(this.path + ".id") && TrueCustomDropsSpigot.useVault.booleanValue()) {
            this.dropMoney();
        }
    }

    @Override
    public void dropItem() {
        this.path = "blocks." + this.worldBlock + ".drops." + this.drop;
        if (!this.defaultDrops) {
            b.setType(Material.AIR);
        }
        if (config.isSet(this.path + ".chance")) {
            if (this.randomChance(config.getDouble(this.path + ".chance"))) {
                b.getWorld().dropItemNaturally(b.getLocation().add(0.5, 0.5, 0.5), this.createItem());
            }
        } else {
            b.getWorld().dropItemNaturally(b.getLocation().add(0.5, 0.5, 0.5), this.createItem());
        }
        this.path = "blocks.";
    }

    @Override
    public void dropMoney() {
        this.path = "blocks." + this.worldBlock + ".drops." + this.drop + ".money";
        if (config.isSet(this.path + ".chance")) {
            if (this.randomChance(config.getDouble(this.path + ".chance"))) {
                EconomyResponse r = economy.depositPlayer((OfflinePlayer)p, config.getDouble(this.path + ".value"));
                if (r.transactionSuccess()) {
                    p.sendMessage(ChatColor.GREEN + String.format("Lucky you! %s has been added to your account!", economy.format(r.amount)));
                } else {
                    p.sendMessage(ChatColor.RED + String.format("An error occured: %s", r.errorMessage));
                }
            }
        } else {
            EconomyResponse r = economy.depositPlayer((OfflinePlayer)p, config.getDouble(this.path + ".value"));
            if (r.transactionSuccess()) {
                p.sendMessage(ChatColor.GREEN + String.format("%s has been added to your account!", economy.format(r.amount)));
            } else {
                p.sendMessage(ChatColor.RED + String.format("An error occured: %s", r.errorMessage));
            }
        }
        this.path = "blocks.";
    }

    @Override
    public ItemStack createItem() {
        ItemStack item = new ItemStack(config.getInt(this.path + ".id"));
        if (config.isSet(this.path + ".meta")) {
            ItemMeta meta = item.getItemMeta();
            String metaPath = this.path + ".meta";
            if (config.isSet(metaPath + ".name")) {
                meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString(metaPath + ".name")));
            }
            if (config.isSet(metaPath + ".lore")) {
                ArrayList<String> lore = new ArrayList<String>();
                for (String line : config.getStringList(metaPath + ".lore")) {
                    lore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)line));
                }
                meta.setLore(lore);
            }
            if (config.isSet(metaPath + ".enchants")) {
                String enchantPath = metaPath + ".enchants";
                for (String enchant : config.getConfigurationSection(enchantPath).getKeys(false)) {
                    meta.addEnchant(Enchantment.getById((int)config.getInt(enchantPath + "." + enchant + ".id")), config.getInt(enchantPath + "." + enchant + ".level"), true);
                }
            }
            item.setItemMeta(meta);
        }
        if (config.isSet(this.path + ".amount")) {
            item.setAmount(config.getInt(this.path + ".amount"));
        } else if (config.isSet(this.path + ".min") && config.isSet(this.path + ".max")) {
            item.setAmount(this.randomInt(config.getInt(this.path + ".min"), config.getInt(this.path + ".max")));
        }
        return item;
    }
}

