/*
 * Decompiled with CFR 0.152.
 */
package com.thetruecolonel.truecustomdrops;

import com.thetruecolonel.truecustomdrops.Metrics;
import com.thetruecolonel.truecustomdrops.listeners.BlockListener;
import com.thetruecolonel.truecustomdrops.listeners.MobListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class TrueCustomDropsSpigot
extends JavaPlugin {
    public static FileConfiguration config;
    public static TrueCustomDropsSpigot plugin;
    public static final Logger log;
    private File configf;
    public String version = this.getDescription().getVersion();
    public static Economy economy;
    public static Boolean useVault;

    public void onEnable() {
        Metrics metrics = new Metrics(this);
        this.createFiles();
        plugin = this;
        if (this.getConfig().getBoolean("useVault")) {
            useVault = true;
            if (!this.setupEconomy()) {
                log.severe(String.format("[%s] - Disabled due to no Vault dependancy found!", this.getDescription().getName()));
                this.getServer().getPluginManager().disablePlugin((Plugin)this);
                return;
            }
        } else {
            log.warning("\"useVault\" in config.yml is set to false! You will not be able to reward money to anyone!");
            log.warning("If you would like to reward money as a drop, please set \"useVault\" to true and restart your server!");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new BlockListener(economy), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MobListener(economy), (Plugin)this);
    }

    public void onDisable() {
        plugin = null;
    }

    private void createFiles() {
        this.configf = new File(this.getDataFolder(), "config.yml");
        if (!this.configf.exists()) {
            this.configf.getParentFile().mkdirs();
            FileConfiguration config = this.getConfig();
            config.addDefault("useVault", (Object)false);
            config.options().copyDefaults(true);
            this.saveConfig();
        }
        config = new YamlConfiguration();
        try {
            config.load(this.configf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        economy = (Economy)rsp.getProvider();
        return economy != null;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("drops") && sender instanceof Player && args.length == 0) {
            if (sender.hasPermission("truecustomdrops.info")) {
                sender.sendMessage("[TrueCustomDrops] Version: v" + this.version);
            } else {
                sender.sendMessage(ChatColor.RED + "You don't have permission to do that!");
            }
            return true;
        }
        return false;
    }

    static {
        log = Logger.getLogger("Minecraft");
        economy = null;
        useVault = false;
    }
}

