/*
 * Decompiled with CFR 0.152.
 */
package me.TheJokerDev.TrollGUI.utils;

import java.util.UUID;
import me.TheJokerDev.TrollGUI.messages.Files;
import me.TheJokerDev.TrollGUI.utils.SimpleItem;
import me.TheJokerDev.TrollGUI.utils.SkullUtils;
import me.TheJokerDev.TrollGUI.utils.Utils;
import me.TheJokerDev.TrollGUI.utils.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class TrollItems {
    public static ItemStack getTrollSkull() {
        return TrollItems.createItem(Files.getTranslationFile().getConfigurationSection("TrollItems.GeneralItems.TrollSkull.item"));
    }

    public static ItemStack createItem(ConfigurationSection section) {
        String[] var1;
        String color;
        boolean hasLore;
        System.out.println(section.toString());
        int int1 = 0;
        int int2 = 0;
        int int3 = 0;
        SimpleItem item = new SimpleItem(XMaterial.BEDROCK).setDisplayName("&7&oName null");
        boolean hasMaterial = section.get("material") != null;
        XMaterial material = null;
        boolean hasData = section.get("data") != null;
        boolean hasRemoveAttributes = section.get("removeAttributes") != null;
        boolean hasAmount = section.get("amount") != null;
        boolean hasGlow = section.get("glowing") != null;
        boolean hasSkullData = section.get("skull") != null;
        boolean hasColor = section.get("color") != null;
        boolean hasPotionData = section.get("potion") != null;
        boolean hasFireWorkData = section.get("firework") != null;
        boolean hasDisplayName = section.get("meta.name") != null;
        boolean bl = hasLore = section.get("meta.lore") != null;
        if (hasMaterial) {
            try {
                material = XMaterial.valueOf(section.getString("material").toUpperCase());
            }
            catch (IllegalArgumentException e) {
                Utils.sendMessage((CommandSender)Bukkit.getConsoleSender(), true, "&cMaterial on " + section.getName() + " is not valid.");
            }
            if (material != null) {
                item.setMaterial(material);
            }
        }
        if (hasData) {
            int data = section.getInt("data");
            item.setDurability(data);
        }
        if (material == XMaterial.PLAYER_HEAD && hasSkullData) {
            String skullData = section.getString("skull");
            if (skullData.startsWith("base-")) {
                skullData = skullData.replace("base-", "");
                item.setItem(SkullUtils.getHead(skullData));
            } else if (skullData.startsWith("uuid-")) {
                skullData = skullData.replace("uuid-", "");
                UUID uuid = UUID.fromString(skullData);
                item.setItem(SkullUtils.getHead(uuid));
            } else if (skullData.startsWith("name-")) {
                skullData = skullData.replace("name-", "");
                OfflinePlayer pf = Bukkit.getOfflinePlayer((String)skullData);
                item.setItem(SkullUtils.getHead(pf));
            } else if (skullData.startsWith("url-")) {
                skullData = skullData.replace("url-", "");
                skullData = "http://textures.minecraft.net/texture/" + skullData;
                item.setItem(SkullUtils.getHead(skullData));
            }
        }
        if (hasAmount) {
            int amount = section.getInt("amount");
            item.setAmount(amount);
        }
        if (hasGlow) {
            boolean glowing = section.getBoolean("glowing");
            item.setGlowing(glowing);
        }
        if (material == XMaterial.FIREWORK_STAR && hasFireWorkData) {
            ItemMeta meta = item.build().getItemMeta();
            FireworkEffectMeta metaFw = (FireworkEffectMeta)meta;
            color = section.getString("firework");
            Color color1 = null;
            var1 = color.split("-");
            if (var1.length == 3) {
                int1 = Utils.isNumeric(var1[0]) ? Integer.parseInt(var1[0]) : 0;
                int2 = Utils.isNumeric(var1[1]) ? Integer.parseInt(var1[1]) : 0;
                int3 = Utils.isNumeric(var1[2]) ? Integer.parseInt(var1[2]) : 0;
            } else {
                int1 = 0;
                int2 = 0;
                int3 = 0;
            }
            color1 = Color.fromRGB((int)int1, (int)int2, (int)int3);
            FireworkEffect effect = FireworkEffect.builder().withColor(color1).build();
            metaFw.setEffect(effect);
            item.setFireworkEffectMeta(metaFw);
        }
        if (material.name().contains("LEATHER") && hasColor) {
            color = section.getString("color");
            var1 = color.split("-");
            if (var1.length == 3) {
                int1 = Utils.isNumeric(var1[0]) ? Integer.parseInt(var1[0]) : 0;
                int2 = Utils.isNumeric(var1[1]) ? Integer.parseInt(var1[1]) : 0;
                int3 = Utils.isNumeric(var1[2]) ? Integer.parseInt(var1[2]) : 0;
            } else {
                int1 = 0;
                int2 = 0;
                int3 = 0;
            }
            Color color1 = Color.fromRGB((int)int1, (int)int2, (int)int3);
            item.setColor(color1);
        }
        if (hasDisplayName) {
            item.setDisplayName(section.getString("meta.name"));
        }
        if (hasLore) {
            item.setLore(section.getStringList("meta.lore"));
        }
        if (hasRemoveAttributes) {
            // empty if block
        }
        return item.build();
    }

    public static boolean compareItems(ItemStack item1, ItemStack item2) {
        boolean bool = false;
        if (item1 != null && item2 != null && item1.getType() != XMaterial.AIR.parseMaterial() && item1.getType() == item2.getType() && item1.getAmount() == item2.getAmount() && item1.hasItemMeta() && item1.getItemMeta().hasDisplayName() && item1.getItemMeta().getDisplayName().equalsIgnoreCase(item2.getItemMeta().getDisplayName())) {
            bool = true;
        }
        return bool;
    }
}

