/*
 * Decompiled with CFR 0.152.
 */
package me.TheJokerDev.TrollGUI.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.TheJokerDev.TrollGUI.utils.XMaterial;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class SkullUtils {
    public static Map<String, String> cached = new HashMap<String, String>();

    public static String getHeadValue(String name) {
        return SkullUtils.getValue(name);
    }

    public static String getValue(String name) {
        try {
            String result = SkullUtils.getURLContent("https://api.mojang.com/users/profiles/minecraft/" + name);
            Gson g = new Gson();
            JsonObject obj = (JsonObject)g.fromJson(result, JsonObject.class);
            String uid = obj.get("id").toString().replace("\"", "");
            String signature = SkullUtils.getURLContent("https://sessionserver.mojang.com/session/minecraft/profile/" + uid);
            obj = (JsonObject)g.fromJson(signature, JsonObject.class);
            String value = obj.getAsJsonArray("properties").get(0).getAsJsonObject().get("value").getAsString();
            String decoded = new String(Base64.getDecoder().decode(value));
            obj = (JsonObject)g.fromJson(decoded, JsonObject.class);
            String skinURL = obj.getAsJsonObject("textures").getAsJsonObject("SKIN").get("url").getAsString();
            byte[] skinByte = ("{\"textures\":{\"SKIN\":{\"url\":\"" + skinURL + "\"}}}").getBytes();
            return new String(Base64.getEncoder().encode(skinByte));
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getURLContent(String urlStr) {
        BufferedReader in = null;
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            URL url = new URL(urlStr);
            in = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));
            while ((str = in.readLine()) != null) {
                sb.append(str);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    public static ItemStack getHead(OfflinePlayer player) {
        String skinURL = null;
        if (cached.containsKey(player.getName())) {
            skinURL = cached.get(player.getName());
        } else {
            try {
                skinURL = SkullUtils.getHeadValue(player.getName());
            }
            catch (Exception e) {
                System.out.println("ERROR: Loading Url from " + player.getName());
            }
        }
        ItemStack head = new ItemStack(XMaterial.PLAYER_HEAD.parseMaterial(), 1, 3);
        if (skinURL == null) {
            return head;
        }
        cached.put(player.getName(), skinURL);
        return SkullUtils.getHead(skinURL);
    }

    public static ItemStack getHead(String skinURL) {
        ItemStack head = new ItemStack(XMaterial.PLAYER_HEAD.parseMaterial(), 1, 3);
        ItemMeta headMeta = head.getItemMeta();
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", skinURL));
        try {
            Field profileField = headMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        head.setItemMeta(headMeta);
        return head;
    }

    public static ItemStack getHead(UUID uuid) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
        String skinURL = null;
        if (cached.containsKey(player.getName())) {
            skinURL = cached.get(player.getName());
        } else {
            try {
                skinURL = SkullUtils.getHeadValue(player.getName());
            }
            catch (Exception e) {
                System.out.println("ERROR: Loading Url from UUID: " + uuid);
            }
        }
        ItemStack head = new ItemStack(XMaterial.PLAYER_HEAD.parseMaterial(), 1, 3);
        if (skinURL == null) {
            return head;
        }
        cached.put(player.getName(), skinURL);
        return SkullUtils.getHead(skinURL);
    }
}

