/*
 * Decompiled with CFR 0.152.
 */
package NL.martijnpu.TracePlayers;

import NL.martijnpu.TracePlayers.FileManager;
import NL.martijnpu.TracePlayers.main;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

class RunnableTask {
    private String fileName;
    private List<String> data = new ArrayList<String>();
    private List<Integer> dataCounter = new ArrayList<Integer>();

    RunnableTask() {
        this.createName();
        this.data.add("DateTime");
        this.dataCounter.add(0);
        BukkitScheduler scheduler = main.get().getServer().getScheduler();
        scheduler.runTaskTimerAsynchronously((Plugin)main.get(), this::saveAllPlayerData, 0L, 6000L);
    }

    void saveAllPlayerData() {
        main.get().sendConsole("Collecting data");
        StringBuilder newRow = new StringBuilder();
        newRow.append(this.getDateTime());
        int counter = 0;
        for (Player p : Bukkit.getOnlinePlayers()) {
            newRow.append(",").append(p.getPlayerListName());
            newRow.append(",").append(p.getLocation().getWorld().getName()).append("(").append((int)p.getLocation().getX()).append(" ").append((int)p.getLocation().getY()).append(" ").append((int)p.getLocation().getZ()).append(")");
            ++counter;
        }
        this.data.add(newRow.toString());
        this.dataCounter.add(counter);
        while (this.dataCounter.get(0) < counter) {
            this.dataCounter.set(0, this.dataCounter.get(0) + 1);
            this.data.set(0, this.data.get(0) + ",player" + this.dataCounter.get(0) + ",location" + this.dataCounter.get(0));
        }
        for (int i = 1; i < this.data.size(); ++i) {
            while (this.dataCounter.get(i) < counter) {
                this.data.set(i, this.data.get(i) + ",,");
                this.dataCounter.set(i, this.dataCounter.get(i) + 1);
            }
        }
        main.get().sendConsole("Saving data");
        if (!FileManager.saveFile(this.fileName, this.data)) {
            this.createName();
            if (!FileManager.saveFile(this.fileName, this.data)) {
                main.get().sendConsole("[ERROR] Unable to save the data. Ignoring it");
            }
        }
    }

    private String getDateTime() {
        Date date = new Date();
        String strDateFormat = "dd-MM-yyyy HH:mm";
        SimpleDateFormat dateFormat = new SimpleDateFormat(strDateFormat);
        return dateFormat.format(date);
    }

    private String getDate() {
        Date date = new Date();
        String strDateFormat = "yyyy-MM-dd";
        SimpleDateFormat dateFormat = new SimpleDateFormat(strDateFormat);
        return dateFormat.format(date);
    }

    private void createName() {
        String tempStartDateTime = this.fileName = this.getDate();
        int count = 1;
        while (FileManager.checkExists(tempStartDateTime)) {
            tempStartDateTime = this.fileName + " (" + count + ")";
            ++count;
        }
        this.fileName = tempStartDateTime;
        main.get().sendConsole("Created new file \"" + this.fileName + "\"");
    }
}

