/*
 * Decompiled with CFR 0.152.
 */
package me.senkoco.townyspawnui.commands;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.metadata.StringDataField;
import com.palmergames.bukkit.towny.utils.MetaDataUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import me.senkoco.townyspawnui.Main;
import me.senkoco.townyspawnui.utils.metadata.MetaData;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class CommandSpawnUI
implements CommandExecutor {
    static ItemStack noNation = CommandSpawnUI.getItem(Material.BLUE_STAINED_GLASS_PANE, "\u00a7c\u00a7lNation-less Towns", "noNation");
    static ItemStack notPublic = CommandSpawnUI.getItem(Material.PURPLE_STAINED_GLASS_PANE, "\u00a7c\u00a7lPrivate Towns", "notPublic");
    static Plugin plugin = Bukkit.getPluginManager().getPlugin("TownySpawnUI");

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player p = (Player)sender;
        if (!sender.hasPermission("townyspawnui.menu.open")) {
            sender.sendMessage(ChatColor.RED + "You can't do that!");
            return false;
        }
        if (plugin != null && plugin instanceof Main) {
            Main main = (Main)plugin;
        }
        LinkedList<Inventory> inventories = new LinkedList<Inventory>(CommandSpawnUI.getPages());
        p.openInventory((Inventory)inventories.get(0));
        return true;
    }

    public static void openInventory(Player player, int page) {
        LinkedList<Inventory> inventories = new LinkedList<Inventory>(CommandSpawnUI.getPages());
        player.openInventory((Inventory)inventories.get(page));
    }

    public static ItemStack getItem(Material material, String newName, String localizedName) {
        ItemStack it = new ItemStack(material, 1);
        ItemMeta itM = it.getItemMeta();
        if (newName != null) {
            itM.setDisplayName(newName);
        }
        if (localizedName != null) {
            itM.setLocalizedName(localizedName);
        }
        it.setItemMeta(itM);
        return it;
    }

    public static ItemStack getItem(Material material, String newName, String localizedName, ArrayList<String> itemlore) {
        ItemStack it = new ItemStack(material, 1);
        ItemMeta itM = it.getItemMeta();
        if (newName != null) {
            itM.setDisplayName(newName);
        }
        if (localizedName != null) {
            itM.setLocalizedName(localizedName);
        }
        if (itemlore != null) {
            itM.setLore(itemlore);
        }
        it.setItemMeta(itM);
        return it;
    }

    public static void fillEmpty(Inventory inv, ItemStack item) {
        for (int i = 0; i < inv.getSize(); ++i) {
            if (inv.getItem(i) != null) continue;
            inv.setItem(i, item);
        }
    }

    public static void addNoNationsItems(Inventory inv) {
        if (TownyAPI.getInstance().getTownsWithoutNation().size() != 0) {
            inv.setItem(22, noNation);
        }
    }

    public static void addPrivatesItems(Inventory inv) {
        int privateTownsCount = 0;
        for (int j = 0; j < TownyAPI.getInstance().getTowns().size(); ++j) {
            if (((Town)TownyAPI.getInstance().getTowns().get(j)).isPublic()) continue;
            ++privateTownsCount;
        }
        if (privateTownsCount != 0) {
            inv.setItem(18, notPublic);
        }
    }

    public static void setGlobalLore(ArrayList<String> itemlore, Nation nation) {
        itemlore.add("\u00a76\u00a7lLeader\u00a7f\u00a7l: \u00a73\u00a7l" + nation.getKing().getName());
        itemlore.add("\u00a76\u00a7lCapital\u00a7f\u00a7l: \u00a72\u00a7l" + nation.getCapital().getName());
        itemlore.add("\u00a76\u00a7lTowns\u00a7f\u00a7l: \u00a79\u00a7l" + nation.getTowns().size());
        itemlore.add("\u00a76\u00a7lTotal Residents\u00a7f\u00a7l: \u00a7d\u00a7l" + nation.getResidents().size());
    }

    public static int getPagesCount(int nationsCount) {
        return nationsCount / 7;
    }

    public static List<Inventory> getPages() {
        LinkedList allNations = new LinkedList(TownyUniverse.getInstance().getNations());
        int nationCount = TownyUniverse.getInstance().getNations().size();
        int nationsCount = 0;
        int inventorySlots = 7;
        LinkedList<Inventory> inventories = new LinkedList<Inventory>();
        for (int pageNumber = 0; pageNumber < CommandSpawnUI.getPagesCount(nationCount) + 1; ++pageNumber) {
            Inventory newPage = Bukkit.createInventory(null, (int)27, (String)("\u00a76\u00a7lTowny\u00a7f\u00a7l: \u00a73\u00a7lNations (" + (pageNumber + 1) + ")"));
            LinkedList<Nation> nations = new LinkedList<Nation>();
            if (pageNumber == CommandSpawnUI.getPagesCount(nationCount)) {
                inventorySlots = nationCount - nationsCount;
            }
            for (int j = 0; j < inventorySlots; ++j) {
                nations.add((Nation)allNations.get(nationsCount));
                ++nationsCount;
            }
            int menuSlot = 10;
            for (int k = 0; k < nations.size(); ++k) {
                Nation nation = (Nation)nations.get(k);
                Material material = Material.valueOf((String)plugin.getConfig().getString("menu.defaultItem"));
                if (MetaDataUtil.hasMeta((TownyObject)nation, (StringDataField)MetaData.blockInMenu)) {
                    material = Material.valueOf((String)MetaData.getBlockInMenu(nation));
                }
                ArrayList<String> itemlore = new ArrayList<String>();
                CommandSpawnUI.setGlobalLore(itemlore, nation);
                newPage.setItem(menuSlot, CommandSpawnUI.getItem(material, "\u00a7c\u00a7l" + nation.getName(), nation.getName(), itemlore));
                ++menuSlot;
            }
            CommandSpawnUI.addNoNationsItems(newPage);
            CommandSpawnUI.addPrivatesItems(newPage);
            if (CommandSpawnUI.getPagesCount(nationCount) > 0) {
                if (pageNumber == 0) {
                    newPage.setItem(23, CommandSpawnUI.getItem(Material.ARROW, "\u00a76\u00a7lNext Page", "" + (pageNumber + 1)));
                } else if (pageNumber == CommandSpawnUI.getPagesCount(nationCount)) {
                    newPage.setItem(21, CommandSpawnUI.getItem(Material.ARROW, "\u00a76\u00a7lPrevious Page", "" + (pageNumber - 1)));
                } else {
                    newPage.setItem(23, CommandSpawnUI.getItem(Material.ARROW, "\u00a76\u00a7lNext Page", "" + (pageNumber + 1)));
                    newPage.setItem(21, CommandSpawnUI.getItem(Material.ARROW, "\u00a76\u00a7lPrevious Page", "" + (pageNumber - 1)));
                }
            }
            CommandSpawnUI.fillEmpty(newPage, CommandSpawnUI.getItem(Material.BLACK_STAINED_GLASS_PANE, " ", "nationMenu"));
            inventories.add(newPage);
        }
        return inventories;
    }
}

