/*
 * Decompiled with CFR 0.152.
 */
package me.senkoco.townyspawnui.commands;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Resident;
import me.senkoco.townyspawnui.utils.metadata.MetaData;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandSetItemTown
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Material material;
        if (!sender.hasPermission("townyspawnui.set.town.item")) {
            sender.sendMessage(ChatColor.RED + "You can't do that!");
            return false;
        }
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.showHelp(sender);
            return false;
        }
        Resident res = TownyAPI.getInstance().getResident((Player)sender);
        if (!res.hasTown()) {
            sender.sendMessage(ChatColor.RED + "You aren't in a town!");
            return false;
        }
        if (!res.isMayor()) {
            sender.sendMessage(ChatColor.RED + "You aren't the mayor of your town!");
            return false;
        }
        try {
            material = Material.valueOf((String)args[0].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            sender.sendMessage(ChatColor.RED + "Please provide a valid item or block name!\n" + ChatColor.RED + "Example: nether_star (Insensitive to case, spaces must be replaced by underscores.");
            return false;
        }
        MetaData.setBlockInMenu(res.getTownOrNull(), material.name());
        sender.sendMessage(ChatColor.GREEN + "Your town's item/block in the menu now is: " + material.name());
        return false;
    }

    private void showHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.RED + "Usage: /town set menu-item <item-name>\n" + ChatColor.RED + "<> = Mandatory");
    }
}

