/*
 * Decompiled with CFR 0.152.
 */
package me.senkoco.townyspawnui;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.metadata.StringDataField;
import com.palmergames.bukkit.towny.utils.MetaDataUtil;
import java.util.ArrayList;
import me.senkoco.townyspawnui.Main;
import me.senkoco.townyspawnui.commands.CommandSpawnUI;
import me.senkoco.townyspawnui.utils.metadata.MetaData;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MainListener
implements Listener {
    ItemStack townFiller = this.getItem(Material.BLACK_STAINED_GLASS_PANE, "\u00a7c\u00a7lClick on any town to teleport to it!", "townMenu");
    int menuSlot = 1;
    Plugin plugin = Bukkit.getPluginManager().getPlugin("TownySpawnUI");

    @EventHandler
    public void onClick(InventoryClickEvent event) {
        if (this.plugin != null && this.plugin instanceof Main) {
            Main main = (Main)this.plugin;
        }
        Inventory inv = event.getInventory();
        Player player = (Player)event.getWhoClicked();
        ItemStack current = event.getCurrentItem();
        if (inv.getItem(0) != null) {
            if (inv.getItem(0).getItemMeta().getLocalizedName().equals("nationMenu")) {
                if (current.getItemMeta().getLocalizedName().equals("noNation")) {
                    this.openNationlessTowns(event, player);
                } else if (current.getItemMeta().getLocalizedName().equals("notPublic")) {
                    this.openPrivateTowns(event, player);
                } else {
                    this.openTownsOfNation(event, current, player);
                }
            } else if (inv.getItem(0).getItemMeta().getLocalizedName().equals("townMenu")) {
                event.setCancelled(true);
                if (current.getItemMeta().getLocalizedName().equals("townMenu")) {
                    return;
                }
                if (current.getItemMeta().getDisplayName().equals("\u00a76\u00a7lNext Page") || current.getItemMeta().getDisplayName().equals("\u00a76\u00a7lPrevious Page") || current.getItemMeta().getDisplayName().equals("\u00a76\u00a7lBack to Nations")) {
                    this.openTownsOfNation(event, current, player);
                } else {
                    this.teleportToTown(player, current.getItemMeta().getLocalizedName());
                }
            }
        }
    }

    public ItemStack getItem(Material material, String newName, String localizedName) {
        ItemStack it = new ItemStack(material, 1);
        ItemMeta itM = it.getItemMeta();
        if (newName != null) {
            itM.setDisplayName(newName);
        }
        if (localizedName != null) {
            itM.setLocalizedName(localizedName);
        }
        it.setItemMeta(itM);
        return it;
    }

    public ItemStack getItemLore(Material material, String newName, String localizedName, ArrayList<String> itemlore) {
        ItemStack it = new ItemStack(material, 1);
        ItemMeta itM = it.getItemMeta();
        if (newName != null) {
            itM.setDisplayName(newName);
        }
        if (localizedName != null) {
            itM.setLocalizedName(localizedName);
        }
        if (itemlore != null) {
            itM.setLore(itemlore);
        }
        it.setItemMeta(itM);
        return it;
    }

    public void openTownsOfNation(InventoryClickEvent event, ItemStack current, Player player) {
        event.setCancelled(true);
        if (current == null || !current.getItemMeta().hasLocalizedName() || current.getItemMeta().getLocalizedName().equals("nationMenu")) {
            return;
        }
        if (current.getItemMeta().getDisplayName().equals("\u00a76\u00a7lNext Page") || current.getItemMeta().getDisplayName().equals("\u00a76\u00a7lPrevious Page") || current.getItemMeta().getDisplayName().equals("\u00a76\u00a7lBack to Nations")) {
            CommandSpawnUI.openInventory(player, Integer.valueOf(current.getItemMeta().getLocalizedName()));
            return;
        }
        Nation nation = TownyAPI.getInstance().getNation(current.getItemMeta().getLocalizedName());
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)("\u00a76\u00a7l" + nation.getName() + "\u00a7f\u00a7l: \u00a73\u00a7lTowns"));
        this.menuSlot = 1;
        if (nation != null) {
            for (int j = 0; j < nation.getTowns().size(); ++j) {
                Town town = (Town)nation.getTowns().get(j);
                if (!town.isPublic()) continue;
                Material material = Material.valueOf((String)this.plugin.getConfig().getString("menu.defaultItem"));
                if (MetaDataUtil.hasMeta((TownyObject)town, (StringDataField)MetaData.blockInMenu)) {
                    material = Material.valueOf((String)MetaData.getBlockInMenu(town));
                }
                ArrayList<String> itemlore = new ArrayList<String>();
                itemlore.add("\u00a76\u00a7lNation\u00a7f\u00a7l: \u00a73\u00a7l" + town.getNationOrNull().getName());
                itemlore.add("\u00a76\u00a7lMayor\u00a7f\u00a7l: \u00a72\u00a7l" + town.getMayor().getName());
                itemlore.add("\u00a76\u00a7lResidents\u00a7f\u00a7l: \u00a7d\u00a7l" + town.getResidents().size());
                itemlore.add("\u00a76\u00a7lSpawn Cost\u00a7f\u00a7l: \u00a7c\u00a7l" + town.getSpawnCost());
                inv.setItem(this.menuSlot, this.getItemLore(material, "\u00a7c\u00a7l" + town.getFormattedName(), town.getName(), itemlore));
                ++this.menuSlot;
            }
        }
        inv.setItem(22, this.getItem(Material.ARROW, "\u00a76\u00a7lBack to Nations", "1"));
        CommandSpawnUI.fillEmpty(inv, this.townFiller);
        player.openInventory(inv);
    }

    public void openNationlessTowns(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"\u00a76\u00a7lNation-less: \u00a73\u00a7lTowns");
        this.menuSlot = 1;
        for (int j = 0; j < TownyAPI.getInstance().getTownsWithoutNation().size(); ++j) {
            Town town = (Town)TownyAPI.getInstance().getTownsWithoutNation().get(j);
            if (!town.isPublic()) continue;
            Material material = Material.RED_STAINED_GLASS_PANE;
            if (MetaDataUtil.hasMeta((TownyObject)town, (StringDataField)MetaData.blockInMenu)) {
                material = Material.valueOf((String)MetaData.getBlockInMenu(town));
            }
            ArrayList<String> itemlore = new ArrayList<String>();
            itemlore.add("\u00a76\u00a7lMayor\u00a7f\u00a7l: \u00a72\u00a7l" + town.getMayor().getName());
            itemlore.add("\u00a76\u00a7lResidents\u00a7f\u00a7l: \u00a7d\u00a7l" + town.getResidents().size());
            itemlore.add("\u00a76\u00a7lSpawn Cost\u00a7f\u00a7l: \u00a7c\u00a7l" + town.getSpawnCost());
            inv.setItem(this.menuSlot, this.getItemLore(material, "\u00a7c\u00a7l" + town.getFormattedName(), town.getName(), itemlore));
            ++this.menuSlot;
        }
        inv.setItem(22, this.getItem(Material.ARROW, "\u00a76\u00a7lBack to Nations", "1"));
        CommandSpawnUI.fillEmpty(inv, this.townFiller);
        player.openInventory(inv);
    }

    public void openPrivateTowns(InventoryClickEvent event, Player player) {
        event.setCancelled(true);
        Inventory inv = Bukkit.createInventory(null, (int)27, (String)"\u00a76\u00a7lPrivate Towns");
        this.menuSlot = 1;
        for (int j = 0; j < TownyAPI.getInstance().getTowns().size(); ++j) {
            Town town = (Town)TownyAPI.getInstance().getTowns().get(j);
            if (town.isPublic()) continue;
            Material material = Material.RED_STAINED_GLASS_PANE;
            if (MetaDataUtil.hasMeta((TownyObject)town, (StringDataField)MetaData.blockInMenu)) {
                material = Material.valueOf((String)MetaData.getBlockInMenu(town));
            }
            ArrayList<String> itemlore = new ArrayList<String>();
            if (town.hasNation()) {
                itemlore.add("\u00a76\u00a7lNation\u00a7f\u00a7l: \u00a73\u00a7l" + town.getNationOrNull().getName());
            }
            itemlore.add("\u00a76\u00a7lMayor\u00a7f\u00a7l: \u00a72\u00a7l" + town.getMayor().getName());
            itemlore.add("\u00a76\u00a7lResidents\u00a7f\u00a7l: \u00a7d\u00a7l" + town.getResidents().size());
            itemlore.add("\u00a76\u00a7lSpawn Cost\u00a7f\u00a7l: \u00a7c\u00a7l" + town.getSpawnCost());
            inv.setItem(this.menuSlot, this.getItemLore(material, "\u00a7c\u00a7l" + town.getFormattedName(), town.getName(), itemlore));
            ++this.menuSlot;
        }
        inv.setItem(22, this.getItem(Material.ARROW, "\u00a76\u00a7lBack to Nations", "1"));
        CommandSpawnUI.fillEmpty(inv, this.townFiller);
        player.openInventory(inv);
    }

    public void teleportToTown(Player player, String townName) {
        Town town = TownyAPI.getInstance().getTown(townName);
        if (!player.hasPermission("townyspawnui.menu.teleport")) {
            player.sendMessage(ChatColor.RED + "You can't do that!");
            return;
        }
        if (!town.isPublic()) {
            return;
        }
        player.performCommand("t spawn " + townName + " -ignore");
        Bukkit.getLogger().info(player.getName() + " teleported to " + townName);
    }
}

