/*
 * Decompiled with CFR 0.152.
 */
package me.coolbey.toplayici.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import me.coolbey.toplayici.Toplayici;
import me.coolbey.toplayici.config.ConfigMessages;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class DropCalculator {
    private ConfigMessages configMessages = new ConfigMessages();
    private Toplayici plugin;
    private final Random RANDOM = new Random();

    public DropCalculator(Toplayici plugin) {
        this.plugin = plugin;
    }

    public ItemStack[] calculate(ItemStack itemInHand, Block block) {
        Collection drops = block.getDrops(itemInHand);
        if (this.isFortuneable(block) && itemInHand.containsEnchantment(Enchantment.LOOT_BONUS_BLOCKS)) {
            ArrayList dropList = new ArrayList();
            if (block.getType() == Material.REDSTONE_ORE || block.getType() == Material.LAPIS_ORE) {
                Iterator iterator = drops.iterator();
                if (iterator.hasNext()) {
                    ItemStack item = (ItemStack)iterator.next();
                    item.setAmount(item.getAmount() + this.getBonus(itemInHand.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS)));
                }
                dropList.addAll(drops);
            } else {
                for (int i = 0; i < 1 + this.getBonus(itemInHand.getEnchantmentLevel(Enchantment.LOOT_BONUS_BLOCKS)); ++i) {
                    dropList.addAll(drops);
                }
            }
            return dropList.toArray(new ItemStack[0]);
        }
        return drops.toArray(new ItemStack[0]);
    }

    public void giveOrDrop(Player player, Collection<ItemStack> items, Location location) {
        HashMap cannotGived = player.getInventory().addItem(items.toArray(new ItemStack[0]));
        if (!this.plugin.getConfig().getBoolean("Settings.isDropMode")) {
            player.getInventory().addItem(items.toArray(new ItemStack[0]));
            if (!cannotGived.isEmpty() && cannotGived.size() > 0 && this.plugin.getConfig().getBoolean("Settings.dropMessage")) {
                player.sendMessage(ConfigMessages.inventoryFull);
            }
        } else if (!cannotGived.isEmpty() && cannotGived.size() > 0) {
            for (ItemStack i : cannotGived.values()) {
                player.getWorld().dropItem(location, i);
            }
            if (this.plugin.getConfig().getBoolean("Settings.isDropMode")) {
                player.sendMessage(ConfigMessages.inventoryFull);
            }
        }
    }

    private int getBonus(int fortuneLevel) {
        int bonus = this.RANDOM.nextInt(fortuneLevel + 2) - 1;
        if (bonus < 0) {
            bonus = 0;
        }
        return bonus;
    }

    private boolean isFortuneable(Block block) {
        return block.getType() == Material.LAPIS_ORE || block.getType() == Material.COAL_ORE || block.getType() == Material.DIAMOND_ORE || block.getType() == Material.EMERALD_ORE || block.getType() == Material.GLOWING_REDSTONE_ORE || block.getType() == Material.GOLD_ORE || block.getType() == Material.IRON_ORE || block.getType() == Material.QUARTZ_ORE || block.getType() == Material.REDSTONE_ORE || block.getType() == Material.CLAY;
    }
}

