/*
 * Decompiled with CFR 0.152.
 */
package me.coolbey.toplayici.events;

import java.util.Arrays;
import me.coolbey.toplayici.Toplayici;
import me.coolbey.toplayici.utils.DropCalculator;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;

public class OnBlockBreakEvent
implements Listener {
    private Toplayici plugin;
    private final DropCalculator CALCULATOR = new DropCalculator(Toplayici.getInstance());

    public OnBlockBreakEvent(Toplayici plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getPlayer().getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Player player = event.getPlayer();
        Block block = event.getBlock();
        ItemStack tool = player.getItemInHand();
        ItemStack[] drops = this.CALCULATOR.calculate(tool, block);
        this.CALCULATOR.giveOrDrop(player, Arrays.asList(drops), block.getLocation());
        player.giveExp(event.getExpToDrop());
        event.setCancelled(true);
        event.getBlock().setType(Material.AIR);
    }
}

