/*
 * Decompiled with CFR 0.152.
 */
package com.tropicbliss.toolbreakagewarning.listeners;

import com.tropicbliss.toolbreakagewarning.ToolBreakageWarning;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemDurabilityLowListener
implements Listener {
    @EventHandler
    public void onItemDurabilityLow(PlayerItemDamageEvent e) {
        Player player = e.getPlayer();
        ItemStack item = e.getItem();
        ItemMeta meta = item.getItemMeta();
        if (meta instanceof Damageable) {
            int unitOfDamage;
            Damageable tool = (Damageable)meta;
            short maxDurability = item.getType().getMaxDurability();
            int previousDurability = maxDurability - tool.getDamage();
            int currentDurability = previousDurability - (unitOfDamage = e.getDamage());
            if (currentDurability <= 0) {
                return;
            }
            double durabilityPercent = (double)currentDurability / (double)maxDurability * 100.0;
            String itemName = item.getType().toString();
            double minPercentageToWarn = itemName.startsWith("DIAMOND_") ? ToolBreakageWarning.getPlugin().getConfig().getDouble("diamondToolWarnPercent") : ToolBreakageWarning.getPlugin().getConfig().getDouble("nonDiamondToolWarnPercent");
            if (durabilityPercent <= minPercentageToWarn) {
                String message = itemName.endsWith("_HELMET") || itemName.endsWith("_CHESTPLATE") || itemName.endsWith("_LEGGINGS") || itemName.endsWith("_BOOTS") || itemName.equals("ELYTRA") ? "An armor you're wearing is about to break" : (itemName.equals("SHIELD") ? "Your shield is about to break" : "The item you're holding is about to break");
                player.sendMessage(ChatColor.RED + message);
            }
        }
    }
}

