/*
 * Decompiled with CFR 0.152.
 */
package kiinse.plugin.thirstforwater.utilities.schedulers;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.logging.Level;
import kiinse.plugin.thirstforwater.ThirstForWater;
import kiinse.plugin.thirstforwater.data.effects.EffectsImpl;
import kiinse.plugin.thirstforwater.data.thirst.interfaces.PlayerThirst;
import kiinse.plugin.thirstforwater.data.timings.interfaces.Timing;
import kiinse.plugin.thirstforwater.data.worlds.enums.WorldsType;
import kiinse.plugin.thirstforwater.data.worlds.interfaces.Worlds;
import kiinse.plugin.thirstforwater.enums.Config;
import kiinse.plugin.thirstforwater.exceptions.ThirstException;
import kiinse.plugin.thirstforwater.exceptions.TimingException;
import kiinse.plugin.thirstforwater.exceptions.WorldsException;
import kiinse.plugin.thirstforwater.utilities.permissions.PermissionUtils;
import kiinse.plugins.darkwaterapi.api.DarkWaterJavaPlugin;
import kiinse.plugins.darkwaterapi.api.files.filemanager.YamlFile;
import kiinse.plugins.darkwaterapi.api.files.filemanager.YamlKeys;
import kiinse.plugins.darkwaterapi.api.schedulers.Scheduler;
import kiinse.plugins.darkwaterapi.api.schedulers.SchedulerData;
import kiinse.plugins.darkwaterapi.core.utilities.DarkPlayerUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

@SchedulerData(name="ThirstSchedule")
public class ThirstSchedule
extends Scheduler {
    private final PermissionUtils permissions;
    private final YamlFile config;
    private final List<String> effects;
    private final ThirstForWater thirstForWater;
    private final Worlds worlds;
    private final Timing timing;
    private final PlayerThirst thirst;

    public ThirstSchedule(@NotNull ThirstForWater thirstForWater) {
        super((DarkWaterJavaPlugin)thirstForWater);
        this.thirstForWater = thirstForWater;
        this.permissions = new PermissionUtils(thirstForWater);
        this.config = thirstForWater.getConfiguration();
        this.effects = new EffectsImpl(thirstForWater).getEffects();
        this.thirst = thirstForWater.getThirst();
        this.worlds = thirstForWater.getWorlds();
        this.timing = thirstForWater.getTiming();
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!DarkPlayerUtils.isSurvivalAdventure((Player)player)) continue;
            World playerWorld = player.getWorld();
            UUID uuid = player.getUniqueId();
            try {
                if (DarkPlayerUtils.isWalking((Player)player)) {
                    if (DarkPlayerUtils.isActing((Player)player)) {
                        if (this.worlds.hasActionWorld(playerWorld)) {
                            if (player.isSprinting() || DarkPlayerUtils.isClimbing((Player)player)) {
                                this.timing.setActions(uuid, this.timing.getActions(uuid) + 2.0);
                            }
                            if (DarkPlayerUtils.isJumping((Player)player) || DarkPlayerUtils.isInLava((Player)player)) {
                                this.timing.setActions(uuid, this.timing.getActions(uuid) + 2.0);
                            }
                            this.removeThirstWorld(player, WorldsType.ACTION, playerWorld);
                        }
                    } else if (this.worlds.hasWalkWorld(playerWorld)) {
                        this.timing.setWalk(uuid, this.timing.getWalk(uuid) + (player.isSneaking() ? 1.2 : 2.0));
                    }
                } else if (this.worlds.hasWalkWorld(playerWorld)) {
                    this.timing.setWalk(uuid, this.timing.getWalk(uuid) + 0.04);
                }
                this.addEffects(player);
                this.removeThirstWorld(player, WorldsType.WALK, playerWorld);
                this.removeThirstPoison(player);
            }
            catch (Exception e) {
                this.thirstForWater.sendLog(Level.WARNING, e.getMessage());
            }
        }
    }

    private void removeThirstPoison(@NotNull Player player) throws ThirstException {
        if (DarkPlayerUtils.isPoisoned((Player)player)) {
            this.thirst.removeFromPlayer(player, this.config.getDouble((YamlKeys)Config.POISONING_REMOVE_SECONDS));
        }
    }

    private void removeThirstWorld(@NotNull Player player, @NotNull WorldsType type, @NotNull World playerWorld) throws TimingException, WorldsException, ThirstException {
        UUID uuid;
        if (this.worlds.hasWorld(type, playerWorld) && this.timing.getTiming(type, uuid = player.getUniqueId()) >= (double)this.worlds.getWorldValue(type, playerWorld)) {
            this.thirst.removeFromPlayer(player, this.permissions.removeThirst(player, type));
            this.timing.setTiming(type, uuid, 0.0);
        }
    }

    private void addEffects(@NotNull Player player) throws ThirstException {
        if ((int)this.thirst.getPlayerValue(player) <= this.config.getInt((YamlKeys)Config.ADD_EFFECTS_THIRST) && this.config.getBoolean((YamlKeys)Config.ADD_EFFECTS_ENABLE)) {
            for (String effect : this.effects) {
                try {
                    player.addPotionEffect(new PotionEffect(Objects.requireNonNull(PotionEffectType.getByName((String)effect)), 50, 1, false, false));
                }
                catch (Exception e) {
                    this.thirstForWater.sendLog(Level.WARNING, "Error on giving player '&a" + DarkPlayerUtils.getPlayerName((CommandSender)player) + "&6' effect: &a" + e.getMessage());
                }
            }
        }
    }
}

