/*
 * Decompiled with CFR 0.152.
 */
package kiinse.plugin.thirstforwater.utilities.schedulers;

import java.util.logging.Level;
import kiinse.plugin.thirstforwater.ThirstForWater;
import kiinse.plugin.thirstforwater.data.thirst.interfaces.PlayerThirst;
import kiinse.plugin.thirstforwater.enums.Config;
import kiinse.plugin.thirstforwater.exceptions.ThirstException;
import kiinse.plugins.darkwaterapi.api.DarkWaterJavaPlugin;
import kiinse.plugins.darkwaterapi.api.files.filemanager.YamlKeys;
import kiinse.plugins.darkwaterapi.api.schedulers.Scheduler;
import kiinse.plugins.darkwaterapi.api.schedulers.SchedulerData;
import kiinse.plugins.darkwaterapi.core.utilities.DarkPlayerUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@SchedulerData(name="DamageSchedule")
public class DamageSchedule
extends Scheduler {
    private final ThirstForWater thirstForWater;
    private final PlayerThirst thirst;

    public DamageSchedule(@NotNull ThirstForWater thirstForWater) {
        super((DarkWaterJavaPlugin)thirstForWater);
        this.thirstForWater = thirstForWater;
        this.thirst = thirstForWater.getThirst();
    }

    public void run() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!DarkPlayerUtils.isSurvivalAdventure((Player)player)) continue;
            try {
                this.damagePlayer(player);
            }
            catch (ThirstException e) {
                this.thirstForWater.sendLog(Level.WARNING, e.getMessage());
            }
        }
    }

    private void damagePlayer(@NotNull Player player) throws ThirstException {
        if (this.thirst.getPlayerValue(player) <= 0.0 && player.getHealth() > 0.0) {
            player.damage((double)this.thirstForWater.getConfiguration().getInt((YamlKeys)Config.DAMAGE));
        }
    }
}

