/*
 * Decompiled with CFR 0.152.
 */
package kiinse.plugin.thirstforwater.utilities.placeholders;

import com.google.common.base.Strings;
import java.util.Objects;
import java.util.logging.Level;
import kiinse.plugin.thirstforwater.ThirstForWater;
import kiinse.plugin.thirstforwater.data.thirst.interfaces.PlayerThirst;
import kiinse.plugin.thirstforwater.enums.Config;
import kiinse.plugin.thirstforwater.enums.Message;
import kiinse.plugin.thirstforwater.enums.ThirstReplace;
import kiinse.plugin.thirstforwater.exceptions.ThirstException;
import kiinse.plugins.darkwaterapi.api.files.filemanager.YamlFile;
import kiinse.plugins.darkwaterapi.api.files.filemanager.YamlKeys;
import kiinse.plugins.darkwaterapi.api.files.locale.PlayerLocales;
import kiinse.plugins.darkwaterapi.api.files.messages.Messages;
import kiinse.plugins.darkwaterapi.api.files.messages.MessagesKeys;
import kiinse.plugins.darkwaterapi.api.files.messages.ReplaceKeys;
import kiinse.plugins.darkwaterapi.core.utilities.DarkUtils;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class IndicatorExpansion
extends PlaceholderExpansion {
    private final ThirstForWater thirstForWater;
    private final PlayerThirst playerThirst;
    private final Messages messages;
    private final PlayerLocales locales;
    private final YamlFile config;

    public IndicatorExpansion(@NotNull ThirstForWater thirstForWater) {
        this.thirstForWater = thirstForWater;
        this.config = thirstForWater.getConfiguration();
        this.playerThirst = thirstForWater.getThirst();
        this.messages = thirstForWater.getMessages();
        this.locales = thirstForWater.getDarkWaterAPI().getPlayerLocales();
    }

    public boolean canRegister() {
        return true;
    }

    @NotNull
    public String getAuthor() {
        return (String)this.thirstForWater.getDescription().getAuthors().get(0);
    }

    @NotNull
    public String getIdentifier() {
        return "tfw";
    }

    @NotNull
    public String getVersion() {
        return this.thirstForWater.getDescription().getVersion();
    }

    public String onPlaceholderRequest(Player player, @NotNull String identifier) {
        if (player == null) {
            return "";
        }
        double thirst = 0.0;
        try {
            thirst = this.playerThirst.getPlayerValue(player);
        }
        catch (ThirstException e) {
            this.thirstForWater.sendLog(Level.WARNING, e.getMessage());
        }
        return switch (identifier) {
            case "thirst" -> this.messages.getStringMessage(this.locales.getLocale(player), (MessagesKeys)Message.PH_THIRST);
            case "numeric" -> this.numericFunc(thirst);
            case "status" -> this.statusFunc(player, thirst);
            case "indicator_simple" -> this.indicatorSimpleFunc(thirst);
            case "indicator" -> this.indicatorFunc(thirst);
            default -> null;
        };
    }

    private String numericFunc(double thirst) {
        if (thirst > 100.0) {
            return "100";
        }
        return String.valueOf(Double.valueOf(thirst).intValue());
    }

    private String statusFunc(Player player, double thirst) {
        if (thirst >= 100.0) {
            return this.messages.getStringMessage(this.locales.getLocale(player), (MessagesKeys)Message.PH_NO_THIRST);
        }
        if (thirst < 100.0 && thirst >= 70.0) {
            return this.messages.getStringMessage(this.locales.getLocale(player), (MessagesKeys)Message.PH_LIGHT_THIRST);
        }
        if (thirst < 70.0 && thirst >= 40.0) {
            return this.messages.getStringMessage(this.locales.getLocale(player), (MessagesKeys)Message.PH_MEDIUM_THIRST);
        }
        if (thirst < 40.0 && thirst >= 10.0) {
            return this.messages.getStringMessage(this.locales.getLocale(player), (MessagesKeys)Message.PH_HARD_THIRST);
        }
        if (thirst < 10.0) {
            return this.messages.getStringMessage(this.locales.getLocale(player), (MessagesKeys)Message.PH_CRITICAL_THIRST);
        }
        return "NaN";
    }

    private String indicatorSimpleFunc(double thirst) {
        if (thirst > 100.0) {
            return ChatColor.DARK_BLUE + "----------";
        }
        if (thirst <= 0.0) {
            return ChatColor.DARK_RED + "----------";
        }
        if (thirst <= 19.0) {
            return this.getProgressBar((int)thirst, ChatColor.RED);
        }
        return this.getProgressBar((int)thirst, ChatColor.AQUA);
    }

    private String indicatorFunc(double thirst) {
        if (thirst > 100.0) {
            return DarkUtils.colorize((String)this.config.getString((YamlKeys)Config.INDICATOR_FULL));
        }
        if (thirst <= 0.0) {
            return DarkUtils.colorize((String)this.config.getString((YamlKeys)Config.INDICATOR_EMPTY));
        }
        return this.getIndicator(Double.valueOf(thirst).intValue());
    }

    private String getProgressBar(int current, @NotNull ChatColor completedColor) {
        int progressBars = (int)(10.0f * ((float)current / 100.0f));
        return Strings.repeat((String)(completedColor + "-"), (int)progressBars) + Strings.repeat((String)(ChatColor.DARK_GRAY + "-"), (int)(10 - progressBars));
    }

    private String getIndicator(int thirst) {
        return DarkUtils.colorize((String)DarkUtils.replaceWord((String)this.config.getString((YamlKeys)Config.INDICATOR_FORMAT), (ReplaceKeys)ThirstReplace.INDICATOR, (String)DarkUtils.getProgressBar((int)thirst, (int)100, (int)10, (String)Objects.requireNonNull(this.config.getString((YamlKeys)Config.INDICATOR_CHAR_FIRST)), (String)Objects.requireNonNull(this.config.getString((YamlKeys)Config.INDICATOR_CHAR_SECOND)))));
    }
}

