/*
 * Decompiled with CFR 0.152.
 */
package kiinse.plugin.thirstforwater.recipes;

import java.util.Objects;
import kiinse.plugin.thirstforwater.enums.Config;
import kiinse.plugin.thirstforwater.enums.File;
import kiinse.plugin.thirstforwater.recipes.interfaces.ThirstRecipes;
import kiinse.plugins.darkwaterapi.api.DarkWaterJavaPlugin;
import kiinse.plugins.darkwaterapi.api.files.filemanager.FilesKeys;
import kiinse.plugins.darkwaterapi.api.files.filemanager.YamlFile;
import kiinse.plugins.darkwaterapi.api.files.filemanager.YamlKeys;
import kiinse.plugins.darkwaterapi.api.utilities.ItemStackUtils;
import kiinse.plugins.darkwaterapi.core.utilities.DarkItemUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class Recipes
extends YamlFile
implements ThirstRecipes {
    private final DarkWaterJavaPlugin plugin;
    private final ItemStackUtils utils;

    public Recipes(@NotNull DarkWaterJavaPlugin plugin) {
        super(plugin, (FilesKeys)File.ITEMS_YML);
        this.plugin = plugin;
        this.utils = new DarkItemUtils(plugin);
    }

    @Override
    @NotNull
    public ItemStack getCleanWater() {
        return Objects.requireNonNull(this.getItemStack(Config.WATER));
    }

    @Override
    @NotNull
    public ItemStack getWaterBottle() {
        return this.utils.getPotionItemStack(null, null, PotionType.WATER, 1);
    }

    @Override
    @NotNull
    public ItemStack getBottle() {
        return this.utils.getItemStack(Material.GLASS_BOTTLE, null, null, 1);
    }

    @Override
    @NotNull
    public ItemStack getSnowBall() {
        return this.utils.getItemStack(Material.SNOWBALL, null, null, 1);
    }

    @Override
    @NotNull
    public ItemStack getFilter() {
        return Objects.requireNonNull(this.getItemStack(Config.FILTER));
    }

    @Override
    public void addFilterRecipes() {
        Bukkit.getServer().addRecipe((Recipe)this.getFilterRecipe("filter_coal", this.getFilter(), new ItemStack(Material.COAL), new ItemStack(Material.PAPER)));
        Bukkit.getServer().addRecipe((Recipe)this.getFilterRecipe("filter_charcoal", this.getFilter(), new ItemStack(Material.CHARCOAL), new ItemStack(Material.PAPER)));
        this.plugin.sendLog("Filter recipes created");
    }

    @Override
    public void addCleanBottleRecipes() {
        Bukkit.getServer().addRecipe((Recipe)this.utils.getShapelessRecipe("clean_water_table", this.getCleanWater(), this.getFilter(), this.getWaterBottle()));
        Bukkit.getServer().addRecipe((Recipe)this.utils.getFurnaceRecipe("clear_water_furnace", this.getCleanWater(), (float)this.plugin.getConfiguration().getDouble((YamlKeys)Config.COOKING_EXPERIENCE), this.plugin.getConfiguration().getInt((YamlKeys)Config.COOKING_TIME)));
        this.plugin.sendLog("Clear water bottle recipes created");
    }

    @Override
    public void addBottleRecipes() {
        Bukkit.getServer().addRecipe((Recipe)this.utils.getShapelessRecipe("water_snow_table", this.getWaterBottle(), this.getSnowBall(), this.getBottle()));
        this.plugin.sendLog("Water bottle recipes created");
    }

    @Override
    public void removeRecipe() {
        Bukkit.getServer().removeRecipe(Objects.requireNonNull(NamespacedKey.fromString((String)"clear_water_furnace")));
        Bukkit.getServer().removeRecipe(Objects.requireNonNull(NamespacedKey.fromString((String)"clear_water_table")));
        Bukkit.getServer().removeRecipe(Objects.requireNonNull(NamespacedKey.fromString((String)"water_snow_table")));
        Bukkit.getServer().removeRecipe(Objects.requireNonNull(NamespacedKey.fromString((String)"filter_charcoal")));
        Bukkit.getServer().removeRecipe(Objects.requireNonNull(NamespacedKey.fromString((String)"filter_coal")));
    }

    @Override
    @NotNull
    public ShapedRecipe getFilterRecipe(@NotNull String key, @NotNull ItemStack result, @NotNull ItemStack ingredient1, @NotNull ItemStack ingredient2) {
        ShapedRecipe recipe = new ShapedRecipe(new NamespacedKey((Plugin)this.plugin, key), result);
        recipe.shape(new String[]{"CCC", "PPP"});
        recipe.setIngredient('C', (RecipeChoice)new RecipeChoice.ExactChoice(ingredient1));
        recipe.setIngredient('P', (RecipeChoice)new RecipeChoice.ExactChoice(ingredient2));
        return recipe;
    }
}

