/*
 * Decompiled with CFR 0.152.
 */
package kiinse.plugin.thirstforwater.listeners;

import java.util.logging.Level;
import kiinse.plugin.thirstforwater.ThirstForWater;
import kiinse.plugin.thirstforwater.data.thirst.interfaces.PlayerThirst;
import kiinse.plugin.thirstforwater.data.timings.interfaces.Timing;
import kiinse.plugin.thirstforwater.exceptions.ThirstException;
import kiinse.plugin.thirstforwater.utilities.ThirstUtils;
import kiinse.plugins.darkwaterapi.core.utilities.DarkPlayerUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.jetbrains.annotations.NotNull;

public class OnJoinListener
implements Listener {
    private final ThirstForWater thirstForWater = ThirstForWater.getInstance();
    private final PlayerThirst thirst = this.thirstForWater.getThirst();
    private final Timing timing = this.thirstForWater.getTiming();

    @EventHandler
    public void joinEvent(@NotNull PlayerJoinEvent event) throws ThirstException {
        Player player = event.getPlayer();
        this.timing.addTimingPlayer(player.getUniqueId());
        if (!this.thirst.hasPlayer(player)) {
            this.thirst.putPlayer(player, 110.0);
        }
        if (!player.hasPlayedBefore()) {
            ThirstUtils.giveItemsAtFirstJoin(player);
        }
        this.thirstForWater.sendLog(Level.CONFIG, "Player " + DarkPlayerUtils.getPlayerName((CommandSender)player) + " joined. His thirst is " + this.thirst.getPlayerValue(player));
    }
}

