/*
 * Decompiled with CFR 0.152.
 */
package kiinse.plugin.thirstforwater.data.worlds;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import kiinse.plugin.thirstforwater.data.worlds.enums.WorldsType;
import kiinse.plugin.thirstforwater.data.worlds.interfaces.Worlds;
import kiinse.plugin.thirstforwater.enums.Config;
import kiinse.plugin.thirstforwater.enums.File;
import kiinse.plugin.thirstforwater.exceptions.WorldsException;
import kiinse.plugins.darkwaterapi.api.DarkWaterJavaPlugin;
import kiinse.plugins.darkwaterapi.api.files.filemanager.FilesKeys;
import kiinse.plugins.darkwaterapi.api.files.filemanager.YamlFile;
import org.bukkit.World;
import org.jetbrains.annotations.NotNull;

public class WorldsImpl
extends YamlFile
implements Worlds {
    private final DarkWaterJavaPlugin plugin;
    private final HashMap<String, Integer> walkWorlds = new HashMap();
    private final HashMap<String, Integer> actionWorlds = new HashMap();

    public WorldsImpl(@NotNull DarkWaterJavaPlugin plugin) throws WorldsException {
        super(plugin, (FilesKeys)File.WORLDS_YML);
        this.plugin = plugin;
        this.load();
    }

    @Override
    public void load() throws WorldsException {
        String[] raw;
        this.walkWorlds.clear();
        this.actionWorlds.clear();
        List walkWorldsList = this.getStringList(Config.WORLD_WALK);
        List actionWorldsList = this.getStringList(Config.WORLD_ACTION);
        if (walkWorldsList.isEmpty()) {
            throw new IllegalArgumentException("walkWorlds list is empty!");
        }
        for (String rawData : walkWorldsList) {
            raw = rawData.split(":");
            this.walkWorlds.put(raw[0], Integer.valueOf(raw[1]));
            this.plugin.sendLog(Level.CONFIG, "Walk world: " + raw[0] + " | Value: " + Double.valueOf(raw[1]));
        }
        this.plugin.sendLog("Walk worlds hashmap loaded");
        if (actionWorldsList.isEmpty()) {
            throw new WorldsException("actionWorlds list is empty!");
        }
        for (String rawData : actionWorldsList) {
            raw = rawData.split(":");
            this.actionWorlds.put(raw[0], Integer.valueOf(raw[1]));
            this.plugin.sendLog(Level.CONFIG, "Action world: " + raw[0] + " | Value: " + Double.valueOf(raw[1]));
        }
        this.plugin.sendLog("Action worlds hashmap loaded");
    }

    @Override
    public boolean hasWorld(@NotNull WorldsType type, @NotNull World world) {
        if (type == WorldsType.ACTION) {
            return this.hasActionWorld(world);
        }
        return this.hasWalkWorld(world);
    }

    @Override
    public boolean hasWalkWorld(@NotNull World world) {
        return this.walkWorlds.containsKey(world.getName());
    }

    @Override
    public boolean hasActionWorld(@NotNull World world) {
        return this.actionWorlds.containsKey(world.getName());
    }

    @Override
    public int getWorldValue(@NotNull WorldsType type, @NotNull World world) throws WorldsException {
        if (type == WorldsType.ACTION) {
            return this.getActionWorldValue(world);
        }
        return this.getWalkWorldValue(world);
    }

    @Override
    public int getWalkWorldValue(@NotNull World world) throws WorldsException {
        if (this.hasWalkWorld(world)) {
            return this.walkWorlds.get(world.getName());
        }
        throw new WorldsException("World not found");
    }

    @Override
    public int getActionWorldValue(@NotNull World world) throws WorldsException {
        if (this.hasActionWorld(world)) {
            return this.actionWorlds.get(world.getName());
        }
        throw new WorldsException("World not found");
    }
}

