/*
 * Decompiled with CFR 0.152.
 */
package kiinse.plugin.thirstforwater.data.timings;

import java.util.HashMap;
import java.util.UUID;
import kiinse.plugin.thirstforwater.data.timings.interfaces.Timing;
import kiinse.plugin.thirstforwater.data.worlds.enums.WorldsType;
import kiinse.plugin.thirstforwater.exceptions.TimingException;
import org.jetbrains.annotations.NotNull;

public class TimingImpl
implements Timing {
    private static final HashMap<UUID, Double> actions = new HashMap();
    private static final HashMap<UUID, Double> walk = new HashMap();

    @Override
    public boolean hasActionsUUID(@NotNull UUID uuid) {
        return actions.containsKey(uuid);
    }

    @Override
    public boolean hasWalkUUID(@NotNull UUID uuid) {
        return walk.containsKey(uuid);
    }

    @Override
    public double getActions(@NotNull UUID uuid) {
        if (!this.hasActionsUUID(uuid)) {
            this.setActions(uuid, 0.0);
        }
        return actions.get(uuid);
    }

    @Override
    public double getWalk(@NotNull UUID uuid) {
        if (!this.hasWalkUUID(uuid)) {
            this.setWalk(uuid, 0.0);
        }
        return walk.get(uuid);
    }

    @Override
    public double getTiming(@NotNull WorldsType type, @NotNull UUID uuid) throws TimingException {
        if (type == WorldsType.ACTION) {
            return this.getActions(uuid);
        }
        return this.getWalk(uuid);
    }

    @Override
    public void setActions(@NotNull UUID uuid, double value) {
        if (!this.hasActionsUUID(uuid)) {
            actions.put(uuid, value);
            return;
        }
        actions.replace(uuid, value);
    }

    @Override
    public void setWalk(@NotNull UUID uuid, double value) {
        if (!this.hasWalkUUID(uuid)) {
            walk.put(uuid, value);
            return;
        }
        walk.replace(uuid, value);
    }

    @Override
    public void setTiming(@NotNull WorldsType type, @NotNull UUID uuid, double value) {
        if (type == WorldsType.ACTION) {
            this.setActions(uuid, value);
            return;
        }
        this.setWalk(uuid, value);
    }

    @Override
    public void addTimingPlayer(@NotNull UUID uuid) {
        if (!this.hasWalkUUID(uuid)) {
            this.setWalk(uuid, 0.0);
        }
        if (!this.hasActionsUUID(uuid)) {
            this.setActions(uuid, 0.0);
        }
    }
}

