/*
 * Decompiled with CFR 0.152.
 */
package kiinse.plugin.thirstforwater.data.thirst.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;
import kiinse.plugin.thirstforwater.ThirstForWater;
import kiinse.plugin.thirstforwater.data.thirst.interfaces.PlayerThirst;
import kiinse.plugin.thirstforwater.data.thirst.sql.database.tables.Players;
import kiinse.plugin.thirstforwater.data.thirst.sql.database.tables.records.PlayersRecord;
import kiinse.plugin.thirstforwater.exceptions.ThirstException;
import kiinse.plugins.darkwaterapi.core.utilities.DarkPlayerUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Record1;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.Table;
import org.jooq.TableLike;

public class PlayerThirstSql
implements PlayerThirst {
    private final Connection connection;
    private final DSLContext context;
    private final ThirstForWater thirstForWater;

    public PlayerThirstSql(ThirstForWater thirstForWater) {
        this.thirstForWater = thirstForWater;
        this.context = thirstForWater.getThirstSQL().getContext();
        this.connection = thirstForWater.getThirstSQL().getConnection();
    }

    @Override
    public boolean hasPlayer(@NotNull Player player) {
        return this.context.select((SelectFieldOrAsterisk[])Players.PLAYERS.fields()).from((TableLike)Players.PLAYERS).where(Players.PLAYERS.UUID.equal((Object)player.getUniqueId())).fetch().isNotEmpty();
    }

    @Override
    @NotNull
    public PlayerThirst putPlayer(@NotNull Player player, double value) {
        PlayersRecord newRecord = (PlayersRecord)this.context.newRecord((Table)Players.PLAYERS);
        newRecord.set((Field)Players.PLAYERS.UUID, player.getUniqueId());
        newRecord.set((Field)Players.PLAYERS.NAME, DarkPlayerUtils.getPlayerName((CommandSender)player));
        newRecord.set((Field)Players.PLAYERS.VALUE, value);
        newRecord.store();
        this.thirstForWater.sendLog(Level.CONFIG, "Player '" + player.getUniqueId() + "' saved to database");
        return this;
    }

    @Override
    @NotNull
    public PlayerThirst updatePlayer(@NotNull Player player, double value) {
        this.context.update((Table)Players.PLAYERS).set(Players.PLAYERS.VALUE, (Object)value).where(Players.PLAYERS.UUID.eq((Object)player.getUniqueId())).execute();
        return this;
    }

    @Override
    public double getPlayerValue(@NotNull Player player) {
        return (Double)((Record1)this.context.select(Players.PLAYERS.VALUE).from((TableLike)Players.PLAYERS).where(Players.PLAYERS.UUID.equal((Object)player.getUniqueId())).fetch().get(0)).component1();
    }

    @Override
    public double getPlayerValue(@NotNull UUID uuid) {
        return (Double)((Record1)this.context.select(Players.PLAYERS.VALUE).from((TableLike)Players.PLAYERS).where(Players.PLAYERS.UUID.equal((Object)uuid)).fetch().get(0)).component1();
    }

    @Override
    @NotNull
    public PlayerThirst addToPlayer(@NotNull Player player, double value) throws ThirstException {
        if (this.hasPlayer(player)) {
            this.updatePlayer(player, Math.min(this.getPlayerValue(player) + value, 110.0));
            return this;
        }
        throw new ThirstException("Player not found");
    }

    @Override
    @NotNull
    public PlayerThirst removeFromPlayer(@NotNull Player player, double value) throws ThirstException {
        if (this.hasPlayer(player)) {
            this.updatePlayer(player, Math.max(this.getPlayerValue(player) - value, 0.0));
            return this;
        }
        throw new ThirstException("Player not found");
    }

    @Override
    @NotNull
    public PlayerThirst restorePlayer(@NotNull Player player) {
        this.updatePlayer(player, 110.0);
        this.thirstForWater.sendLog(Level.CONFIG, "Player '" + player.getUniqueId() + "' thirst restored");
        return this;
    }

    @Override
    @NotNull
    public PlayerThirst save() throws ThirstException {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                this.thirstForWater.sendLog(Level.CONFIG, "Postgresql connection closed");
            }
            return this;
        }
        catch (SQLException e) {
            throw new ThirstException(e);
        }
    }
}

