/*
 * Decompiled with CFR 0.152.
 */
package kiinse.plugin.thirstforwater.data.thirst.json;

import java.util.UUID;
import java.util.logging.Level;
import kiinse.plugin.thirstforwater.ThirstForWater;
import kiinse.plugin.thirstforwater.data.thirst.interfaces.PlayerThirst;
import kiinse.plugin.thirstforwater.enums.File;
import kiinse.plugin.thirstforwater.exceptions.ThirstException;
import kiinse.plugins.darkwaterapi.api.DarkWaterJavaPlugin;
import kiinse.plugins.darkwaterapi.api.exceptions.JsonFileException;
import kiinse.plugins.darkwaterapi.api.files.filemanager.FilesKeys;
import kiinse.plugins.darkwaterapi.api.files.filemanager.JsonFile;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class PlayerThirstJson
implements PlayerThirst {
    private final JSONObject thirstJson;
    private final JsonFile json;
    private final ThirstForWater thirstForWater;

    public PlayerThirstJson(@NotNull ThirstForWater thirstForWater) throws ThirstException {
        try {
            this.thirstForWater = thirstForWater;
            this.json = new JsonFile((DarkWaterJavaPlugin)thirstForWater, (FilesKeys)File.DATA_JSON);
            this.thirstJson = this.json.getJsonFromFile();
        }
        catch (JsonFileException e) {
            throw new ThirstException(e);
        }
    }

    @Override
    public boolean hasPlayer(@NotNull Player player) {
        return this.thirstJson.has(player.getUniqueId().toString());
    }

    @Override
    @NotNull
    public PlayerThirst putPlayer(@NotNull Player player, double value) {
        this.thirstJson.put(player.getUniqueId().toString(), value);
        this.thirstForWater.sendLog(Level.CONFIG, "Player '" + player.getUniqueId() + "' saved to json");
        return this;
    }

    @Override
    @NotNull
    public PlayerThirst updatePlayer(@NotNull Player player, double value) {
        this.thirstJson.remove(player.getUniqueId().toString());
        this.thirstJson.put(player.getUniqueId().toString(), value);
        return this;
    }

    @Override
    public double getPlayerValue(@NotNull Player player) throws ThirstException {
        if (this.thirstJson.has(player.getUniqueId().toString())) {
            return this.thirstJson.getDouble(player.getUniqueId().toString());
        }
        throw new ThirstException("Player not found");
    }

    @Override
    public double getPlayerValue(@NotNull UUID uuid) throws ThirstException {
        if (this.thirstJson.has(uuid.toString())) {
            return this.thirstJson.getDouble(uuid.toString());
        }
        throw new ThirstException("Player not found");
    }

    @Override
    @NotNull
    public PlayerThirst addToPlayer(@NotNull Player player, double value) throws ThirstException {
        if (this.hasPlayer(player)) {
            this.updatePlayer(player, Math.min(this.getPlayerValue(player) + value, 110.0));
            return this;
        }
        throw new ThirstException("Player not found");
    }

    @Override
    @NotNull
    public PlayerThirst removeFromPlayer(@NotNull Player player, double value) throws ThirstException {
        if (this.hasPlayer(player)) {
            this.updatePlayer(player, Math.max(this.getPlayerValue(player) - value, 0.0));
            return this;
        }
        throw new ThirstException("Player not found");
    }

    @Override
    @NotNull
    public PlayerThirst restorePlayer(@NotNull Player player) {
        this.updatePlayer(player, 110.0);
        this.thirstForWater.sendLog(Level.CONFIG, "Player '" + player.getUniqueId() + "' thirst restored");
        return this;
    }

    @Override
    @NotNull
    public PlayerThirst save() throws ThirstException {
        try {
            this.json.saveJsonToFile(this.thirstJson);
            this.thirstForWater.sendLog(Level.CONFIG, "JsonObject saved to file");
            return this;
        }
        catch (JsonFileException e) {
            throw new ThirstException(e);
        }
    }
}

