/*
 * Decompiled with CFR 0.152.
 */
package kiinse.plugin.thirstforwater;

import com.vdurmont.semver4j.Semver;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.logging.Level;
import kiinse.plugin.thirstforwater.data.thirst.interfaces.PlayerThirst;
import kiinse.plugin.thirstforwater.data.thirst.json.PlayerThirstJson;
import kiinse.plugin.thirstforwater.data.thirst.sql.PlayerThirstSql;
import kiinse.plugin.thirstforwater.data.thirst.sql.ThirstSQL;
import kiinse.plugin.thirstforwater.data.timings.TimingImpl;
import kiinse.plugin.thirstforwater.data.timings.interfaces.Timing;
import kiinse.plugin.thirstforwater.data.worlds.WorldsImpl;
import kiinse.plugin.thirstforwater.data.worlds.interfaces.Worlds;
import kiinse.plugin.thirstforwater.enums.Config;
import kiinse.plugin.thirstforwater.initialize.LoadAPI;
import kiinse.plugin.thirstforwater.initialize.RegisterEvents;
import kiinse.plugin.thirstforwater.recipes.CreateRecipes;
import kiinse.plugin.thirstforwater.recipes.Recipes;
import kiinse.plugin.thirstforwater.recipes.RemoveRecipes;
import kiinse.plugin.thirstforwater.recipes.interfaces.ThirstRecipes;
import kiinse.plugin.thirstforwater.utilities.schedulers.DamageSchedule;
import kiinse.plugin.thirstforwater.utilities.schedulers.ThirstSchedule;
import kiinse.plugins.darkwaterapi.api.DarkWaterJavaPlugin;
import kiinse.plugins.darkwaterapi.api.DarkWaterMain;
import kiinse.plugins.darkwaterapi.api.exceptions.VersioningException;
import kiinse.plugins.darkwaterapi.api.files.filemanager.YamlKeys;
import kiinse.plugins.darkwaterapi.api.indicators.Indicator;
import kiinse.plugins.darkwaterapi.api.indicators.IndicatorManager;
import kiinse.plugins.darkwaterapi.api.schedulers.Scheduler;
import kiinse.plugins.darkwaterapi.api.schedulers.SchedulersManager;
import kiinse.plugins.darkwaterapi.api.utilities.TaskType;
import kiinse.plugins.darkwaterapi.core.utilities.DarkUtils;
import kiinse.plugins.darkwaterapi.core.utilities.DarkVersionUtils;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class ThirstForWater
extends DarkWaterJavaPlugin {
    private static ThirstForWater instance;
    private Indicator indicator;
    private Scheduler damageScheduler;
    private Scheduler thirstScheduler;
    private SchedulersManager schedulersManager;
    private IndicatorManager indicatorManager;
    private ThirstSQL thirstSQL;
    private PlayerThirst thirst;
    private Worlds worlds;
    private Timing timing;
    private ThirstRecipes recipes;

    @NotNull
    public static ThirstForWater getInstance() {
        return instance;
    }

    public void onStart() throws Exception {
        instance = this;
        DarkWaterMain darkWater = this.getDarkWaterAPI();
        this.indicatorManager = darkWater.getIndicatorManager();
        this.schedulersManager = darkWater.getSchedulersManager();
        if (this.getConfiguration().getBoolean((YamlKeys)Config.PG_ENABLED)) {
            this.thirstSQL = new ThirstSQL(this);
            this.thirst = new PlayerThirstSql(this);
        } else {
            this.thirst = new PlayerThirstJson(this);
        }
        this.timing = new TimingImpl();
        this.worlds = new WorldsImpl(this);
        this.recipes = new Recipes(this);
        new LoadAPI(this);
        new CreateRecipes(this);
        new RegisterEvents(this);
        this.indicator = Indicator.valueOf((Plugin)this, (String)"%tfw_indicator%", (int)0);
        if (this.getConfiguration().getBoolean((YamlKeys)Config.INDICATOR_ACTIONBAR)) {
            this.indicatorManager.register((DarkWaterJavaPlugin)this, this.indicator);
        }
        this.damageScheduler = new DamageSchedule(this);
        this.thirstScheduler = new ThirstSchedule(this);
        this.schedulersManager.register(this.damageScheduler);
        this.schedulersManager.register(this.thirstScheduler);
        this.checkForUpdates();
    }

    public void onStop() throws Exception {
        this.thirst.save();
        this.indicatorManager.removeIndicator(this.indicator);
        this.schedulersManager.unregister(this.damageScheduler);
        this.schedulersManager.unregister(this.thirstScheduler);
        new RemoveRecipes(this);
    }

    private void checkForUpdates() {
        DarkUtils.runTask((TaskType)TaskType.ASYNC, (DarkWaterJavaPlugin)this, () -> {
            if (!this.getConfiguration().getBoolean((YamlKeys)Config.DISABLE_VERSION_CHECK)) {
                try {
                    Semver latest = DarkVersionUtils.getLatestGithubVersion((String)"https://github.com/NubilumDev/ThirstForWater");
                    if (!latest.isGreaterThan(DarkVersionUtils.getPluginVersion((DarkWaterJavaPlugin)this))) {
                        this.sendLog("Latest version of ThirstForWater installed, no new versions found <3");
                        return;
                    }
                    BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("version-message.txt"))));
                    StringBuilder builder = new StringBuilder("\n");
                    while (reader.ready()) {
                        builder.append(reader.readLine()).append("\n");
                    }
                    this.sendConsole(DarkUtils.replaceWord((String)builder.toString(), (String[])new String[]{"{NEW_VERSION}:" + latest.getOriginalValue(), "{CURRENT_VERSION}:" + this.getDescription().getVersion()}));
                }
                catch (IOException | VersioningException e) {
                    this.sendLog(Level.WARNING, "Error while checking ThirstForWater version! Message: " + e.getMessage());
                }
            }
        });
    }

    @NotNull
    public PlayerThirst getThirst() {
        return this.thirst;
    }

    @NotNull
    public ThirstSQL getThirstSQL() {
        return this.thirstSQL;
    }

    @NotNull
    public Timing getTiming() {
        return this.timing;
    }

    @NotNull
    public Worlds getWorlds() {
        return this.worlds;
    }

    @NotNull
    public ThirstRecipes getRecipes() {
        return this.recipes;
    }
}

