/*
 * Decompiled with CFR 0.152.
 */
package me.PauMAVA.TTR.world;

import me.PauMAVA.TTR.TTRCore;
import org.bukkit.Difficulty;
import org.bukkit.GameRule;
import org.bukkit.World;

public class TTRWorldHandler {
    private TTRCore plugin;
    private World matchWorld;
    private Difficulty originalDifficulty;

    public TTRWorldHandler(TTRCore plugin, World matchWorld) {
        this.plugin = plugin;
        this.matchWorld = matchWorld;
        this.originalDifficulty = matchWorld.getDifficulty();
    }

    public void setUpWorld() {
        this.matchWorld.setSpawnLocation(this.plugin.getConfigManager().getLobbyLocation());
    }

    public void configureWeather() {
        this.setWeatherCycle(false);
        String weatherType = this.plugin.getConfigManager().getWeather();
        if (weatherType.equalsIgnoreCase("rain") || weatherType.equalsIgnoreCase("thunder")) {
            this.matchWorld.setStorm(true);
            if (weatherType.equalsIgnoreCase("thunder")) {
                this.matchWorld.setThundering(true);
            }
        } else if (weatherType.equalsIgnoreCase("clear")) {
            this.matchWorld.setStorm(false);
            this.matchWorld.setThundering(false);
        }
    }

    public void configureTime() {
        this.setDayLightCycle(false);
        this.matchWorld.setTime((long)this.plugin.getConfigManager().getTime());
    }

    public void enableDayLightCycle() {
        this.setDayLightCycle(true);
    }

    public void enableWeatherCycle() {
        this.setWeatherCycle(true);
    }

    public void restoreDifficulty() {
        this.matchWorld.setDifficulty(this.originalDifficulty);
    }

    public void setWorldDifficulty(Difficulty difficulty) {
        this.matchWorld.setDifficulty(difficulty);
    }

    private void setWeatherCycle(boolean value) {
        this.matchWorld.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)value);
    }

    private void setDayLightCycle(boolean value) {
        this.matchWorld.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)value);
    }
}

