/*
 * Decompiled with CFR 0.152.
 */
package me.PauMAVA.TTR.ui;

import me.PauMAVA.TTR.TTRCore;
import me.PauMAVA.TTR.teams.TTRTeam;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.ScoreboardManager;

public class TTRScoreboard {
    private ScoreboardManager scoreboardManager = Bukkit.getScoreboardManager();
    private Scoreboard ttrScoreboard = this.scoreboardManager.getNewScoreboard();
    private Objective kills = this.ttrScoreboard.registerNewObjective("kills", "dummy", ChatColor.LIGHT_PURPLE + "kills");
    private Objective health;
    private Objective points;
    private Score totalTime;
    private int taskPID;

    public TTRScoreboard() {
        this.kills.setDisplaySlot(DisplaySlot.PLAYER_LIST);
        this.health = this.ttrScoreboard.registerNewObjective("showhealth", "health", ChatColor.RED + "\u2764");
        this.health.setDisplaySlot(DisplaySlot.BELOW_NAME);
        this.points = this.ttrScoreboard.registerNewObjective("points", "dummy", ChatColor.AQUA + ChatColor.BOLD + "Points");
        this.points.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    public void refreshScoreboard() {
        this.updatePoints();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            player.setScoreboard(this.ttrScoreboard);
            this.kills.getScore(player.getName()).setScore(TTRCore.getInstance().getCurrentMatch().getKills(player));
        }
    }

    public void removeScoreboard() {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            player.setScoreboard(this.scoreboardManager.getMainScoreboard());
        }
    }

    public void startScoreboardTask() {
        this.taskPID = new BukkitRunnable(){
            private int i = 0;

            public void run() {
                TTRScoreboard.this.updatePoints();
                TTRScoreboard.this.points.getScore(ChatColor.DARK_GRAY + "\u00a7m                         ").setScore(-1);
                if (TTRScoreboard.this.totalTime != null) {
                    TTRScoreboard.this.ttrScoreboard.resetScores(TTRScoreboard.this.totalTime.getEntry());
                }
                TTRScoreboard.this.totalTime = TTRScoreboard.this.points.getScore(ChatColor.GREEN + ChatColor.BOLD + "Total time: " + ChatColor.GRAY + this.prettyTime(this.i));
                TTRScoreboard.this.totalTime.setScore(-2);
                ++this.i;
                TTRScoreboard.this.refreshScoreboard();
            }

            private String prettyTime(int i) {
                String elapsedMinutes = i % 86400 % 3600 / 60 < 10 ? "0" + i % 86400 % 3600 / 60 : "" + i % 86400 % 3600 / 60;
                String elapsedSeconds = i % 86400 % 3600 % 60 < 10 ? "0" + i % 86400 % 3600 % 60 : "" + i % 86400 % 3600 % 60;
                return i % 86400 / 3600 + ":" + elapsedMinutes + ":" + elapsedSeconds;
            }
        }.runTaskTimer((Plugin)TTRCore.getInstance(), 0L, 20L).getTaskId();
        this.refreshScoreboard();
    }

    private void updatePoints() {
        for (TTRTeam team : TTRCore.getInstance().getTeamHandler().getTeams()) {
            ChatColor teamColor = TTRCore.getInstance().getConfigManager().getTeamColor(team.getIdentifier());
            this.points.getScore(teamColor + ChatColor.BOLD + team.getIdentifier()).setScore(team.getPoints());
        }
    }

    public void stopScoreboardTask() {
        Bukkit.getScheduler().cancelTask(this.taskPID);
    }
}

