/*
 * Decompiled with CFR 0.152.
 */
package me.PauMAVA.TTR.teams;

import java.util.ArrayList;
import java.util.List;
import me.PauMAVA.TTR.TTRCore;
import me.PauMAVA.TTR.match.TTRMatch;
import me.PauMAVA.TTR.teams.TTRTeam;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class TTRTeamHandler {
    private TTRMatch match = TTRCore.getInstance().getCurrentMatch();
    private List<TTRTeam> teams = new ArrayList<TTRTeam>();

    public void setUpDefaultTeams() {
        for (String team : TTRCore.getInstance().getConfigManager().getTeamNames()) {
            this.teams.add(new TTRTeam(team));
        }
    }

    public boolean addPlayerToTeam(Player player, String teamIdentifier) {
        TTRTeam team = this.getTeam(teamIdentifier);
        if (team == null) {
            return false;
        }
        team.addPlayer(player);
        return true;
    }

    public boolean removePlayerFromTeam(Player player, String teamIdentifier) {
        TTRTeam team = this.getTeam(teamIdentifier);
        if (team == null) {
            return false;
        }
        team.removePlayer(player);
        return true;
    }

    public TTRTeam getPlayerTeam(Player player) {
        for (TTRTeam team : this.teams) {
            if (!team.getPlayers().contains(player)) continue;
            return team;
        }
        return null;
    }

    public TTRTeam getTeam(String teamIdentifier) {
        for (TTRTeam team : this.teams) {
            if (!(teamIdentifier = ChatColor.stripColor((String)teamIdentifier)).contentEquals(team.getIdentifier())) continue;
            return team;
        }
        return null;
    }

    public List<TTRTeam> getTeams() {
        return this.teams;
    }

    public void addPlayer(String teamIdentifier, Player player) {
        this.getTeam(teamIdentifier).addPlayer(player);
    }

    public void removePlayer(String teamIdentifier, Player player) {
        this.getTeam(teamIdentifier).removePlayer(player);
    }
}

