/*
 * Decompiled with CFR 0.152.
 */
package me.PauMAVA.TTR.match;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import me.PauMAVA.TTR.TTRCore;
import me.PauMAVA.TTR.match.CageChecker;
import me.PauMAVA.TTR.match.LootSpawner;
import me.PauMAVA.TTR.match.MatchStatus;
import me.PauMAVA.TTR.teams.TTRTeam;
import me.PauMAVA.TTR.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Difficulty;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TTRMatch {
    private MatchStatus status;
    private LootSpawner lootSpawner;
    private CageChecker checker;
    private HashMap<Player, Integer> kills = new HashMap();

    public TTRMatch(MatchStatus initialStatus) {
        this.status = initialStatus;
    }

    public boolean isOnCourse() {
        return this.status == MatchStatus.INGAME;
    }

    public void startMatch() {
        this.status = MatchStatus.INGAME;
        this.lootSpawner = new LootSpawner();
        this.checker = new CageChecker();
        this.checker.setCages(TTRCore.getInstance().getConfigManager().getTeamCages(), 2);
        this.checker.startChecking();
        this.lootSpawner.startSpawning();
        TTRCore.getInstance().getWorldHandler().configureTime();
        TTRCore.getInstance().getWorldHandler().configureWeather();
        TTRCore.getInstance().getWorldHandler().setWorldDifficulty(Difficulty.PEACEFUL);
        TTRCore.getInstance().getScoreboard().startScoreboardTask();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            TTRTeam playerTeam = TTRCore.getInstance().getTeamHandler().getPlayerTeam(player);
            if (playerTeam == null) continue;
            player.teleport(TTRCore.getInstance().getConfigManager().getTeamSpawn(playerTeam.getIdentifier()));
            player.getInventory().clear();
            player.setExp(0.0f);
            player.setGameMode(GameMode.SURVIVAL);
            double health = TTRCore.getInstance().getConfigManager().getMaxHealth();
            AttributeInstance maxHealth = player.getAttribute(Attribute.GENERIC_MAX_HEALTH);
            maxHealth.setBaseValue(health);
            player.setHealthScale(health);
            player.setHealth(health);
            player.setFoodLevel(20);
            player.setSaturation(20.0f);
            this.setPlayerArmor(player);
            this.kills.put(player, 0);
        }
    }

    public void endMatch(TTRTeam team) {
        this.status = MatchStatus.ENDED;
        this.lootSpawner.stopSpawning();
        TTRCore.getInstance().getScoreboard().stopScoreboardTask();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            player.setGameMode(GameMode.SPECTATOR);
            ChatColor teamColor = TTRCore.getInstance().getConfigManager().getTeamColor(team.getIdentifier());
            player.sendTitle(teamColor + ChatColor.BOLD + team.getIdentifier(), ChatColor.AQUA + "WINS!", 10, 100, 20);
            player.playSound(player.getLocation(), Sound.UI_TOAST_CHALLENGE_COMPLETE, 10.0f, 1.0f);
        }
        TTRCore.getInstance().getWorldHandler().enableDayLightCycle();
        TTRCore.getInstance().getWorldHandler().enableWeatherCycle();
        TTRCore.getInstance().getWorldHandler().restoreDifficulty();
    }

    public void playerDeath(final Player player, final Player killer) {
        new BukkitRunnable(){

            public void run() {
                try {
                    Object packet = ReflectionUtils.createNMSInstance("PacketPlayInClientCommand", List.of(), List.of());
                    Class<?> enumClientCommand = ReflectionUtils.getNMSClass("PacketPlayInClientCommand$EnumClientCommand");
                    Object performRespawnConstant = null;
                    for (Object constant : enumClientCommand.getEnumConstants()) {
                        if (!constant.toString().equalsIgnoreCase("PERFORM_RESPAWN")) continue;
                        performRespawnConstant = constant;
                        break;
                    }
                    if (performRespawnConstant == null) {
                        throw new IllegalStateException("Class PacketPlayInClientCommand.EnumClientCommand does not contain a PERFORM_RESPAWN constant...");
                    }
                    Field a = packet.getClass().getDeclaredField("a");
                    a.setAccessible(true);
                    a.set(packet, performRespawnConstant);
                    Object playerConnection = ReflectionUtils.getPlayerConnection(player);
                    Class<?> packetClass = ReflectionUtils.getNMSClass("PacketPlayInClientCommand");
                    Method aMethod = playerConnection.getClass().getMethod("a", packetClass);
                    aMethod.invoke(playerConnection, packetClass.cast(packet));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                TTRTeam team = TTRCore.getInstance().getTeamHandler().getPlayerTeam(player);
                if (team != null) {
                    player.teleport(TTRCore.getInstance().getConfigManager().getTeamSpawn(team.getIdentifier()));
                }
                TTRMatch.this.setPlayerArmor(player);
                player.playSound(player.getLocation(), Sound.BLOCK_NOTE_BLOCK_CHIME, 10.0f, 1.0f);
                player.playSound(player.getLocation(), Sound.BLOCK_GLASS_BREAK, 10.0f, 1.0f);
                this.cancel();
                TTRMatch.this.kills.put(killer, TTRMatch.this.getKills(killer) + 1);
            }
        }.runTaskLater((Plugin)TTRCore.getInstance(), 2L);
    }

    private void setPlayerArmor(Player player) {
        ItemStack[] armor;
        TTRTeam team = TTRCore.getInstance().getTeamHandler().getPlayerTeam(player);
        if (team == null) {
            return;
        }
        ChatColor color = TTRCore.getInstance().getConfigManager().getTeamColor(team.getIdentifier());
        for (ItemStack itemStack : armor = new ItemStack[]{new ItemStack(Material.LEATHER_BOOTS, 1), new ItemStack(Material.LEATHER_LEGGINGS, 1), new ItemStack(Material.LEATHER_CHESTPLATE, 1), new ItemStack(Material.LEATHER_HELMET, 1)}) {
            LeatherArmorMeta meta = (LeatherArmorMeta)itemStack.getItemMeta();
            Color armorColor = Color.fromRGB((int)0, (int)0, (int)0);
            try {
                meta.setColor((Color)armorColor.getClass().getDeclaredField(color.name()).get(armorColor));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
            meta.addEnchant(Enchantment.VANISHING_CURSE, 1, true);
            itemStack.setItemMeta((ItemMeta)meta);
        }
        player.getInventory().setArmorContents(armor);
    }

    public MatchStatus getStatus() {
        return this.status;
    }

    public int getKills(Player player) {
        return this.kills.getOrDefault(player, 0);
    }
}

