/*
 * Decompiled with CFR 0.152.
 */
package me.PauMAVA.TTR.match;

import java.util.List;
import me.PauMAVA.TTR.TTRCore;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LootSpawner {
    private List<Location> ironLocations = TTRCore.getInstance().getConfigManager().getIronSpawns();
    private List<Location> xpLocations = TTRCore.getInstance().getConfigManager().getXPSpawns();
    private long ironFrequency = 150L;
    private long xpFrequency = 150L;
    private int ironTaskPID;
    private int xpTaskPID;

    public void startSpawning() {
        this.setIronTask();
        this.setXpTask();
    }

    public void stopSpawning() {
        Bukkit.getScheduler().cancelTask(this.ironTaskPID);
        Bukkit.getScheduler().cancelTask(this.xpTaskPID);
    }

    private void setIronTask() {
        this.ironTaskPID = new BukkitRunnable(){

            public void run() {
                for (Location location : LootSpawner.this.ironLocations) {
                    Location copy = new Location(location.getWorld(), location.getX(), location.getY(), location.getZ());
                    copy.add(location.getX() > 0.0 ? 0.5 : 0.5, 0.0, location.getZ() > 0.0 ? 0.5 : -0.5);
                    location.getWorld().dropItem(copy, new ItemStack(Material.IRON_INGOT, 1));
                }
            }
        }.runTaskTimer((Plugin)TTRCore.getInstance(), 0L, this.ironFrequency).getTaskId();
    }

    private void setXpTask() {
        this.xpTaskPID = new BukkitRunnable(){

            public void run() {
                for (Location location : LootSpawner.this.xpLocations) {
                    Location copy = new Location(location.getWorld(), location.getX(), location.getY(), location.getZ());
                    copy.add(location.getX() > 0.0 ? 0.5 : 0.5, 0.0, location.getZ() > 0.0 ? 0.5 : -0.5);
                    location.getWorld().spawnEntity(copy, EntityType.THROWN_EXP_BOTTLE);
                }
            }
        }.runTaskTimer((Plugin)TTRCore.getInstance(), 0L, this.xpFrequency).getTaskId();
    }
}

