/*
 * Decompiled with CFR 0.152.
 */
package me.PauMAVA.TTR.match;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.PauMAVA.TTR.TTRCore;
import me.PauMAVA.TTR.match.Cage;
import me.PauMAVA.TTR.teams.TTRTeam;
import me.PauMAVA.TTR.util.TTRPrefix;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CageChecker {
    private List<Cage> cages = new ArrayList<Cage>();
    private int checkerTaskPID;

    public void startChecking() {
        this.checkerTaskPID = new BukkitRunnable(){

            public void run() {
                for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                    for (Cage cage : CageChecker.this.cages) {
                        Location particleLocation;
                        particleLocation.add((particleLocation = new Location(cage.getLocation().getWorld(), (double)cage.getLocation().getBlockX(), (double)(cage.getLocation().getBlockY() + 1), (double)cage.getLocation().getBlockZ())).getX() > 0.0 ? 0.5 : -0.5, 0.0, particleLocation.getZ() > 0.0 ? 0.5 : -0.5);
                        cage.getLocation().getWorld().spawnParticle(Particle.SPELL, particleLocation, 100);
                        if (!cage.isInCage(p) || TTRCore.getInstance().getTeamHandler().getPlayerTeam(p) == null) continue;
                        if (cage.getOwner().equals(TTRCore.getInstance().getTeamHandler().getPlayerTeam(p))) {
                            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_BASS, 10.0f, 1.0f);
                            p.sendMessage(TTRPrefix.TTR_GAME + ChatColor.RED + "You can't do that!");
                            p.teleport(TTRCore.getInstance().getConfigManager().getTeamSpawn(TTRCore.getInstance().getTeamHandler().getPlayerTeam(p).getIdentifier()));
                            continue;
                        }
                        cage.getLocation().getWorld().strikeLightningEffect(cage.getLocation());
                        CageChecker.this.playerOnCage(p);
                    }
                }
            }
        }.runTaskTimer((Plugin)TTRCore.getInstance(), 0L, 10L).getTaskId();
    }

    public void stopChecking() {
        Bukkit.getScheduler().cancelTask(this.checkerTaskPID);
    }

    private void playerOnCage(Player player) {
        TTRTeam playersTeam = TTRCore.getInstance().getTeamHandler().getPlayerTeam(player);
        player.teleport(TTRCore.getInstance().getConfigManager().getTeamSpawn(playersTeam.getIdentifier()));
        playersTeam.addPoints(1);
        TTRCore.getInstance().getScoreboard().refreshScoreboard();
        Bukkit.broadcastMessage((String)(TTRPrefix.TTR_GAME + ChatColor.GRAY + player.getName() + " has scored a point!"));
        for (Player p : Bukkit.getServer().getOnlinePlayers()) {
            p.playSound(p.getLocation(), Sound.BLOCK_NOTE_BLOCK_PLING, 10.0f, 1.0f);
        }
        if (playersTeam.getPoints() >= TTRCore.getInstance().getConfigManager().getMaxPoints()) {
            TTRCore.getInstance().getCurrentMatch().endMatch(playersTeam);
        }
    }

    public void setCages(HashMap<Location, TTRTeam> cages, int effectiveRadius) {
        for (Location cage : cages.keySet()) {
            this.cages.add(new Cage(cage, effectiveRadius, cages.get(cage)));
        }
    }
}

