/*
 * Decompiled with CFR 0.152.
 */
package me.PauMAVA.TTR.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import me.PauMAVA.TTR.TTRCore;
import me.PauMAVA.TTR.teams.TTRTeam;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class TTRConfigManager {
    private FileConfiguration configuration;
    private World world;
    private ConfigurationSection teamsSection;
    private ConfigurationSection matchSection;
    private ConfigurationSection mapSection;
    private ConfigurationSection autoStartSection;

    public TTRConfigManager(FileConfiguration configuration) {
        this.configuration = configuration;
        this.world = (World)TTRCore.getInstance().getServer().getWorlds().get(0);
        if (!new File(TTRCore.getInstance().getDataFolder() + "/config.yml").exists()) {
            this.setUpFile();
            this.saveConfig();
        } else {
            this.teamsSection = this.configuration.getConfigurationSection("teams");
            this.mapSection = this.configuration.getConfigurationSection("map");
            this.matchSection = this.configuration.getConfigurationSection("match");
            this.autoStartSection = this.configuration.getConfigurationSection("autostart");
        }
    }

    public int getMaxPoints() {
        return this.matchSection.getInt("maxpoints");
    }

    public int getMaxHealth() {
        return this.matchSection.getInt("maxhealth");
    }

    public int getTime() {
        return this.matchSection.getInt("time");
    }

    public String getWeather() {
        return this.matchSection.getString("weather");
    }

    public Location getLobbyLocation() {
        return this.mapSection.getLocation("lobby");
    }

    public List<Location> getIronSpawns() {
        return this.mapSection.getList("ironspawns");
    }

    public List<Location> getXPSpawns() {
        return this.mapSection.getList("xpspawns");
    }

    public int getTeamCount() {
        return this.teamsSection.getKeys(false).size();
    }

    public Set<String> getTeamNames() {
        return this.teamsSection.getKeys(false);
    }

    private ConfigurationSection getTeam(String teamName) {
        for (String key : this.teamsSection.getKeys(false)) {
            if (!key.equalsIgnoreCase(teamName)) continue;
            return this.teamsSection.getConfigurationSection(key);
        }
        return null;
    }

    public ChatColor getTeamColor(String teamName) {
        return ChatColor.valueOf((String)this.getTeam(teamName).getString("color"));
    }

    public Location getTeamSpawn(String teamName) {
        return this.getTeam(teamName).getLocation("spawn");
    }

    public Location getTeamCage(String teamName) {
        return this.getTeam(teamName).getLocation("cage");
    }

    public HashMap<Location, TTRTeam> getTeamCages() {
        HashMap<Location, TTRTeam> cages = new HashMap<Location, TTRTeam>();
        for (String teamName : this.getTeamNames()) {
            cages.put(this.getTeamCage(teamName), TTRCore.getInstance().getTeamHandler().getTeam(teamName));
        }
        return cages;
    }

    public boolean isEnabled() {
        return this.configuration.getBoolean("enable_on_start");
    }

    public void setEnableOnStart(boolean value) {
        this.configuration.set("enable_on_start", (Object)value);
        this.saveConfig();
    }

    private void saveConfig() {
        TTRCore.getInstance().saveConfig();
    }

    public void resetFile() {
        this.setUpFile();
    }

    private void setUpFile() {
        this.configuration.addDefault("enable_on_start", (Object)false);
        this.autoStartSection = this.configuration.createSection("autostart");
        this.autoStartSection.addDefault("enabled", (Object)true);
        this.autoStartSection.addDefault("count", (Object)4);
        this.matchSection = this.configuration.createSection("match");
        this.matchSection.addDefault("time", (Object)10000);
        this.matchSection.addDefault("weather", (Object)"CLEAR");
        this.matchSection.addDefault("maxpoints", (Object)10);
        this.matchSection.addDefault("maxhealth", (Object)20);
        this.mapSection = this.configuration.createSection("map");
        this.mapSection.addDefault("lobby", (Object)new Location(this.world, 0.0, 207.0, 1014.0));
        this.mapSection.addDefault("ironspawns", new ArrayList<Location>(Arrays.asList(new Location(this.world, 0.0, 206.0, 1138.0))));
        this.mapSection.addDefault("xpspawns", new ArrayList<Location>(Arrays.asList(new Location(this.world, 0.0, 206.0, 1166.0))));
        this.teamsSection = this.configuration.createSection("teams");
        ConfigurationSection team1section = this.teamsSection.createSection("Red Team");
        ConfigurationSection team2section = this.teamsSection.createSection("Blue Team");
        team1section.addDefault("color", (Object)"RED");
        team2section.addDefault("color", (Object)"BLUE");
        team1section.addDefault("spawn", (Object)new Location(this.world, 84.0, 192.0, 1152.0));
        team2section.addDefault("spawn", (Object)new Location(this.world, -83.0, 192.0, 1152.0));
        team1section.addDefault("cage", (Object)new Location(this.world, 84.0, 200.0, 1152.0));
        team2section.addDefault("cage", (Object)new Location(this.world, -83.0, 200.0, 1152.0));
        this.configuration.options().copyDefaults(true);
    }
}

